/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IKeyPressController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.AnchorageContentControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;

public class DelegatingContentAnchorageController
extends ControllerBase {
    private final IKeyPressController defaultKeyPressControllerWithMove = new IKeyPressController(){

        @Override
        public Change keyEvent(KeyEvent event, IMVCBundle bundle, Node source, DiagramCoordinate mouseLocation) {
            DiagramViewer viewer = DelegatingContentAnchorageController.this.getViewer();
            KeyCode code = event.getCode();
            if (code == KeyCode.DELETE) {
                return new Change(){

                    @Override
                    public void applyChange() {
                        DelegatingContentAnchorageController.this.delete();
                    }
                };
            }
            if (code == KeyCode.A && event.isControlDown()) {
                viewer.selectAll();
                return null;
            }
            if (DelegatingContentAnchorageController.this.allowMove() && (code == KeyCode.UP || code == KeyCode.DOWN || code == KeyCode.LEFT || code == KeyCode.RIGHT)) {
                return DelegatingContentAnchorageController.this.keyMove(code);
            }
            return null;
        }
    };

    public DelegatingContentAnchorageController(IContentAnchorageMVCBundle mvcb) {
        super(mvcb);
    }

    private IContentAnchorageMVCBundle getContentAnchorageBundle() {
        return (IContentAnchorageMVCBundle)this.getMVCBundle();
    }

    @Override
    public IDragController getDragController(EDragGesture gesture, Node node, DiagramCoordinate diagramLocation) {
        if (gesture == EDragGesture.MOVE && this.allowMove()) {
            IContentAnchorageMVCBundle contentAnchorageBundle = this.getContentAnchorageBundle();
            IContentMVCBundle parent = contentAnchorageBundle.getAttachedTo();
            if (parent != null && parent.getController() instanceof AnchorageContentControllerBase) {
                AnchorageContentControllerBase parentController = (AnchorageContentControllerBase)parent.getController();
                return parentController.getAnchorageMoveController(contentAnchorageBundle);
            }
            return null;
        }
        return super.getDragController(gesture, node, diagramLocation);
    }

    @Override
    public IKeyPressController getKeyPressController(Node node, DiagramCoordinate lastMouseLocation) {
        return this.defaultKeyPressControllerWithMove;
    }

    @Override
    public Cursor getCurrentCursor(Node node, DiagramCoordinate diagramLocation) {
        EDragGesture edg = this.getVisual().getDragGesture(node, diagramLocation);
        if (edg == EDragGesture.MOVE) {
            return this.allowMove() ? Cursor.MOVE : Cursor.DEFAULT;
        }
        return super.getCurrentCursor(node, diagramLocation);
    }

    protected boolean allowMove() {
        return true;
    }

    protected Change keyMove(KeyCode code) {
        return null;
    }
}

