/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import javafx.scene.Node;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;

public abstract class DragControllerBase
implements IDragController {
    protected IMVCBundle startBundle = null;
    protected Node startNode;
    protected DiagramCoordinate startDiagramLocation = null;

    @Override
    public final void dragStarted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
        this.startBundle = bundle;
        this.startNode = node;
        this.startDiagramLocation = diagramLocation;
        this.safeDragStarted(bundle, node, this.startDiagramLocation);
    }

    protected void safeDragStarted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
    }

    @Override
    public final void dragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
        if (this.isDragInProgress()) {
            this.safeDragInProgress(bundle, node, diagramLocation);
        }
    }

    protected void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
    }

    @Override
    public final Change dragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
        Change result = null;
        if (this.isDragInProgress()) {
            result = this.safeDragCompleted(bundle, node, diagramLocation);
        }
        this.startBundle = null;
        this.startNode = null;
        this.startDiagramLocation = null;
        return result;
    }

    protected Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
        return null;
    }

    protected final boolean isDragInProgress() {
        return this.startBundle != null;
    }

    protected final FeedbackChange getDragDelta(DiagramCoordinate endDiagramLocation) {
        double dx = endDiagramLocation.getX() - this.startDiagramLocation.getX();
        double dy = endDiagramLocation.getY() - this.startDiagramLocation.getY();
        return FeedbackChange.locationFeedbackChange(dx, dy);
    }
}

