/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;

final class DraggingUtils {
    DraggingUtils() {
    }

    public static FeedbackChange clampAndSnapMoveLocationToGridPoint(double x, double y, double dx, double dy, DiagramViewerFeatures features) {
        return DraggingUtils.clampAndSnapMoveLocation(x, y, dx, dy, features, false);
    }

    public static FeedbackChange clampAndSnapMoveLocationToGridCenterPoint(double x, double y, double dx, double dy, DiagramViewerFeatures features) {
        return DraggingUtils.clampAndSnapMoveLocation(x, y, dx, dy, features, true);
    }

    private static FeedbackChange clampAndSnapMoveLocation(double x, double y, double dx, double dy, DiagramViewerFeatures features, boolean snapToCenter) {
        double newx = x + dx + 10.0;
        double newy = y + dy + 10.0;
        if (features.isDrawOuterBorder()) {
            newx = Math.max(newx, features.getHorizontalSpacing());
            newy = Math.max(newy, features.getVerticalSpacing());
        } else {
            newx = Math.max(newx, 0.0);
            newy = Math.max(newy, 0.0);
        }
        if (features.useSnapToGrid()) {
            newx = snapToCenter ? features.snapToCenterX(newx) : features.snapToGridX(newx);
            newy = snapToCenter ? features.snapToCenterY(newy) : features.snapToGridY(newy);
        }
        dx = newx - x;
        dy = newy - y;
        return FeedbackChange.locationFeedbackChange(dx, dy);
    }
}

