/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import java.util.Collections;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerSelection;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IKeyPressController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ClickControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DragControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DraggingUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeProvider;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.MVCBundleTag;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.MVCBundlePartBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;

public abstract class LinkControllerBase
extends MVCBundlePartBase
implements IController {
    private int currentBendPointIndex = 0;

    public LinkControllerBase(ILinkMVCBundle mvcb) {
        super(mvcb);
    }

    @Override
    public IModelChangeProvider getModelChangeProvider() {
        return null;
    }

    protected abstract void createBendPointAt(int var1, DiagramCoordinate var2);

    protected abstract void updateModelAfterBendPointMove(int var1, double var2, double var4);

    protected abstract void deleteBendPoint(int var1);

    protected abstract void updateModelAfterLinkMove(ILinkMVCBundle var1, IMVCBundle var2, IMVCBundle var3);

    protected abstract void deleteLink();

    protected final void setCurrentBendPointIndex(int bendPointIndex) {
        this.currentBendPointIndex = bendPointIndex;
    }

    @Override
    public ILinkMVCBundle getMVCBundle() {
        return (ILinkMVCBundle)super.getMVCBundle();
    }

    protected ILinkVisual getLinkVisual() {
        return this.getMVCBundle().getVisual();
    }

    protected IClickController getBendPointCreateAndLinkSelectController() {
        return new ClickControllerBase(){

            @Override
            public Change singleClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
                DiagramViewer viewer = LinkControllerBase.this.getViewer();
                if (event.isControlDown()) {
                    if (!viewer.isPrimarySelected(LinkControllerBase.this.getMVCBundle())) {
                        return null;
                    }
                    DiagramViewerFeatures features = viewer.getFeatures();
                    DiagramCoordinate snappedLocation = features.snapToCenter(diagramLocation);
                    return () -> LinkControllerBase.this.createBendPointAt(LinkControllerBase.this.currentBendPointIndex, snappedLocation);
                }
                viewer.setSingleSelectedMVCBundle(LinkControllerBase.this.getMVCBundle());
                return null;
            }

            @Override
            public Change secondaryClick(MouseEvent event, Node node, DiagramCoordinate locationOnNode) {
                DiagramViewer viewer = LinkControllerBase.this.getViewer();
                if (event.isControlDown() && viewer.isPrimarySelected(LinkControllerBase.this.getMVCBundle())) {
                    return () -> LinkControllerBase.this.deleteLink();
                }
                viewer.showContextMenu(node, locationOnNode, LinkControllerBase.this.getMVCBundle());
                return null;
            }
        };
    }

    protected IDragController getBendPointMoveController() {
        return new DragControllerBase(){

            @Override
            public void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
                DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
                LinkControllerBase.this.moveBendPointVisually(LinkControllerBase.this.currentBendPointIndex, delta);
                LinkControllerBase.this.getViewer().updateVisual(LinkControllerBase.this.getMVCBundle());
            }

            @Override
            public Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
                DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
                return () -> LinkControllerBase.this.moveBendPointInModel(LinkControllerBase.this.currentBendPointIndex, delta);
            }
        };
    }

    protected void moveBendPointVisually(int bpIndex, Point2D delta) {
        FeedbackChange chg = this.getMoveDeltaFeedback(bpIndex, delta.getX(), delta.getY());
        this.getLinkVisual().setFeedbackChangeForBendPoint(bpIndex, chg);
    }

    protected void moveBendPointVisually(int bpIndex, FeedbackChange change) {
        FeedbackChange chg = this.getMoveDeltaFeedback(bpIndex, change.getDeltaX(), change.getDeltaY());
        this.getLinkVisual().setFeedbackChangeForBendPoint(bpIndex, chg);
    }

    protected final FeedbackChange getMoveDeltaFeedback(int bpIndex, Point2D delta) {
        return this.getMoveDeltaFeedback(bpIndex, delta.getX(), delta.getY());
    }

    protected final FeedbackChange getMoveDeltaFeedback(int bpIndex, double dx, double dy) {
        DiagramCoordinate bpModelLocation = this.getLinkVisual().getBendPointLocation(bpIndex);
        DiagramViewerFeatures features = this.getViewer().getFeatures();
        if (this.clampAndSnapBendPointToGridCenter()) {
            return DraggingUtils.clampAndSnapMoveLocationToGridCenterPoint(bpModelLocation.getX(), bpModelLocation.getY(), dx, dy, features);
        }
        if (this.clampAndSnapBendPointToGrid()) {
            return DraggingUtils.clampAndSnapMoveLocationToGridPoint(bpModelLocation.getX(), bpModelLocation.getY(), dx, dy, features);
        }
        return FeedbackChange.locationFeedbackChange(dx, dy);
    }

    protected boolean clampAndSnapBendPointToGridCenter() {
        return true;
    }

    protected boolean clampAndSnapBendPointToGrid() {
        return false;
    }

    protected void moveBendPointInModel(int bpIndex, Point2D delta) {
        FeedbackChange chg = this.getMoveDeltaFeedback(bpIndex, delta.getX(), delta.getY());
        this.getLinkVisual().setFeedbackChangeForBendPoint(bpIndex, null);
        this.updateModelAfterBendPointMove(bpIndex, chg.getDeltaX(), chg.getDeltaY());
    }

    protected void moveBendPointInModel(int bpIndex, FeedbackChange delta) {
        FeedbackChange chg = this.getMoveDeltaFeedback(bpIndex, delta.getDeltaX(), delta.getDeltaY());
        this.getLinkVisual().setFeedbackChangeForBendPoint(bpIndex, null);
        this.updateModelAfterBendPointMove(bpIndex, chg.getDeltaX(), chg.getDeltaY());
    }

    protected IClickController getBendPointDeleteController() {
        return new ClickControllerBase(){

            @Override
            public Change secondaryClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
                DiagramViewer viewer;
                if (event.isControlDown() && (viewer = LinkControllerBase.this.getViewer()).isPrimarySelected(LinkControllerBase.this.getMVCBundle())) {
                    return () -> LinkControllerBase.this.deleteBendPoint(LinkControllerBase.this.currentBendPointIndex);
                }
                return null;
            }
        };
    }

    @Override
    public IDragController getDragController(EDragGesture gesture, Node node, DiagramCoordinate diagramLocation) {
        DiagramViewerSelection selection = this.getViewer().getSelection();
        ILinkMVCBundle linkBundle = this.getMVCBundle();
        if (selection.getPrimarySelection() == linkBundle) {
            if (!this.getLinkVisual().isBendPointHandle(node)) {
                return null;
            }
            ILinkVisual linkVisual = this.getLinkVisual();
            int bpIndex = linkVisual.getBendPointIndex(node);
            if (bpIndex == Integer.MIN_VALUE || bpIndex == -2147483647) {
                return this.getLinkMoveController(bpIndex);
            }
            if (bpIndex == -2147483646) {
                return null;
            }
            this.setCurrentBendPointIndex(bpIndex);
            return this.getBendPointMoveController();
        }
        if (selection.isSelected(linkBundle)) {
            return new DragControllerBase(){

                @Override
                protected void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
                    FeedbackChange fc = this.getDragDelta(diagramLocation);
                    int numerOfBendPoints = LinkControllerBase.this.getNumerOfBendPoints();
                    int i = 0;
                    while (i < numerOfBendPoints) {
                        LinkControllerBase.this.moveBendPointVisually(i, fc);
                        ++i;
                    }
                }

                @Override
                protected Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
                    FeedbackChange fc = this.getDragDelta(diagramLocation);
                    return () -> {
                        int numerOfBendPoints = LinkControllerBase.this.getNumerOfBendPoints();
                        int i = 0;
                        while (i < numerOfBendPoints) {
                            LinkControllerBase.this.moveBendPointInModel(i, fc);
                            ++i;
                        }
                    };
                }
            };
        }
        return null;
    }

    protected IDragController getLinkMoveController(final int bpIndex) {
        return new DragControllerBase(){

            @Override
            protected void safeDragStarted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
                ILinkMVCBundle linkBundle = LinkControllerBase.this.getMVCBundle();
                IAnchorageMVCBundle anchorage = bpIndex == Integer.MIN_VALUE ? linkBundle.getStartAnchorage() : linkBundle.getEndAnchorage();
                LinkControllerBase.this.getLinkVisual().disableFeedback();
                LinkControllerBase.this.getViewer().startMoveLinkFeedback(linkBundle, anchorage);
            }

            @Override
            public void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
                DiagramCoordinate linkAnchorageLocation = bundle.getVisual().getLinkAnchorage(diagramLocation);
                Object delta = linkAnchorageLocation != null ? linkAnchorageLocation.subtract(this.startDiagramLocation) : diagramLocation.subtract(this.startDiagramLocation);
                FeedbackChange chg = FeedbackChange.locationFeedbackChange(delta.getX(), delta.getY());
                LinkControllerBase.this.getLinkVisual().setFeedbackChangeForBendPoint(bpIndex, chg);
                LinkControllerBase.this.getViewer().updateVisual(LinkControllerBase.this.getMVCBundle());
            }

            @Override
            public Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
                LinkControllerBase.this.getLinkVisual().enableFeedback();
                LinkControllerBase.this.getLinkVisual().setFeedbackChangeForBendPoint(bpIndex, null);
                DiagramViewer viewer = LinkControllerBase.this.getViewer();
                viewer.terminateMoveLinkFeedback();
                ILinkMVCBundle linkBundle = LinkControllerBase.this.getMVCBundle();
                if (bpIndex == Integer.MIN_VALUE) {
                    return () -> LinkControllerBase.this.updateModelAfterLinkMove(linkBundle, bundle, linkBundle.getEndAnchorage());
                }
                return () -> LinkControllerBase.this.updateModelAfterLinkMove(linkBundle, linkBundle.getStartAnchorage(), bundle);
            }
        };
    }

    @Override
    public IClickController getClickController(Node node, DiagramCoordinate diagramLocation) {
        int bpIndex = this.getLinkVisual().getBendPointIndex(node);
        if (bpIndex < -2147483645) {
            return null;
        }
        this.setCurrentBendPointIndex(bpIndex);
        if (this.getLinkVisual().isBendPointHandle(node)) {
            return this.getBendPointDeleteController();
        }
        return this.getBendPointCreateAndLinkSelectController();
    }

    @Override
    public boolean selectOnMousePress() {
        return true;
    }

    @Override
    public boolean selectOnCtrlMousePress() {
        return true;
    }

    @Override
    public IKeyPressController getKeyPressController(Node node, DiagramCoordinate lastMouseLocation) {
        return new IKeyPressController(){

            @Override
            public Change keyEvent(KeyEvent event, IMVCBundle bundle, Node source, DiagramCoordinate mouseLocation) {
                KeyCode code = event.getCode();
                if (code == KeyCode.DELETE) {
                    return () -> LinkControllerBase.this.deleteLink();
                }
                if (code == KeyCode.A && event.isControlDown()) {
                    LinkControllerBase.this.getViewer().selectAll();
                }
                return null;
            }
        };
    }

    @Override
    public List<MenuItem> contextMenuContributions(Node node, DiagramCoordinate diagramLocation) {
        return Collections.emptyList();
    }

    @Override
    public boolean isPossibleLinkTarget() {
        return false;
    }

    @Override
    public MVCBundleTag getLinkTargetEffectForNewLinkFrom(IMVCBundle linkStartBundle) {
        return null;
    }

    @Override
    public MVCBundleTag getLinkTargetEffectForMoveLink(ILinkMVCBundle linkBundle, IAnchorageMVCBundle movedAnchorageBundle) {
        return null;
    }

    @Override
    public Cursor getCurrentCursor(Node node, DiagramCoordinate diagramLocation) {
        EDragGesture edg = this.getVisual().getDragGesture(node, diagramLocation);
        switch (edg) {
            case MOVE_BENDPOINT: {
                return this.allowBendPointMove() ? Cursor.MOVE : Cursor.DEFAULT;
            }
            case NEW_BENDPOINT: {
                return Cursor.CROSSHAIR;
            }
            case RECONNECT_LINK: {
                return this.allowLinkMove() ? Cursor.MOVE : Cursor.DEFAULT;
            }
        }
        return Cursor.DEFAULT;
    }

    protected boolean allowBendPointMove() {
        return true;
    }

    protected boolean allowLinkMove() {
        return true;
    }

    protected abstract int getNumerOfBendPoints();

    @Override
    public boolean handleExternalDNDDragOver(Dragboard db, DiagramCoordinate diagramLocation) {
        return false;
    }

    @Override
    public boolean handleExternalDNDDrop(Dragboard db, DiagramCoordinate diagramLocation) {
        return false;
    }
}

