/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IKeyPressController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DragControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DraggingUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;

public abstract class MoveControllerBase
extends ControllerBase {
    private final IDragController moveController = new DragControllerBase(){

        @Override
        protected final void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            FeedbackChange altered = MoveControllerBase.this.alterMoveFeedback(this.getDragDelta(diagramLocation));
            MoveControllerBase.this.setMoveFeedbackChange(altered, this.startBundle);
        }

        @Override
        protected final Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            MoveControllerBase.this.setMoveFeedbackChange(FeedbackChange.EMPTY, this.startBundle);
            FeedbackChange change = MoveControllerBase.this.alterMoveFeedback(this.getDragDelta(diagramLocation));
            if (change.isEmpty()) {
                return null;
            }
            return new MoveChange(change);
        }
    };

    public MoveControllerBase(IMVCBundle mvcb) {
        super(mvcb);
    }

    @Override
    public IDragController getDragController(EDragGesture gesture, Node node, DiagramCoordinate diagramLocation) {
        if (this.allowMove() && gesture == EDragGesture.MOVE) {
            return this.moveController;
        }
        return super.getDragController(gesture, node, diagramLocation);
    }

    @Override
    public Cursor getCurrentCursor(Node node, DiagramCoordinate diagramLocation) {
        EDragGesture edg = this.getVisual().getDragGesture(node, diagramLocation);
        if (edg == EDragGesture.MOVE) {
            return this.allowMove() ? Cursor.MOVE : Cursor.DEFAULT;
        }
        return super.getCurrentCursor(node, diagramLocation);
    }

    @Override
    public IKeyPressController getKeyPressController(final Node node, final DiagramCoordinate lastMouseLocation) {
        if (this.allowMove() && this.allowKeyboardMove()) {
            return new IKeyPressController(){

                @Override
                public Change keyEvent(KeyEvent event, IMVCBundle bundle, Node source, DiagramCoordinate mouseLocation) {
                    DiagramViewerFeatures features = MoveControllerBase.this.getViewer().getFeatures();
                    double hSpacing = features.getHorizontalSpacing();
                    double vSpacing = features.getVerticalSpacing();
                    FeedbackChange fbChange = null;
                    KeyCode code = event.getCode();
                    if (code == KeyCode.RIGHT) {
                        fbChange = FeedbackChange.locationFeedbackChange(hSpacing, 0.0);
                    } else if (code == KeyCode.LEFT) {
                        fbChange = FeedbackChange.locationFeedbackChange(-hSpacing, 0.0);
                    } else if (code == KeyCode.UP) {
                        fbChange = FeedbackChange.locationFeedbackChange(0.0, -vSpacing);
                    } else if (code == KeyCode.DOWN) {
                        fbChange = FeedbackChange.locationFeedbackChange(0.0, vSpacing);
                    } else {
                        return MoveControllerBase.super.getKeyPressController(node, lastMouseLocation).keyEvent(event, bundle, source, mouseLocation);
                    }
                    if (fbChange != null && !fbChange.isEmpty()) {
                        return new MoveChange(fbChange);
                    }
                    return null;
                }
            };
        }
        return super.getKeyPressController(node, lastMouseLocation);
    }

    protected void move(FeedbackChange deltaChange) {
    }

    protected boolean allowMove() {
        return true;
    }

    protected boolean allowKeyboardMove() {
        return true;
    }

    protected boolean clampAndSnapMove() {
        return true;
    }

    protected boolean moveChildren() {
        return true;
    }

    private void setMoveFeedbackChange(FeedbackChange change, IMVCBundle bundle) {
        bundle.setFeedbackChange(change);
        if (this.moveChildren() && bundle instanceof IContentMVCBundle) {
            IContentMVCBundle cb = (IContentMVCBundle)bundle;
            for (IMVCBundle iMVCBundle : cb.getChildren()) {
                this.setMoveFeedbackChange(change, iMVCBundle);
            }
        }
    }

    protected FeedbackChange alterMoveFeedback(FeedbackChange change) {
        if (!this.clampAndSnapMove()) {
            return change;
        }
        Rectangle2D modelBounds = this.getVisual().getModelBounds();
        return DraggingUtils.clampAndSnapMoveLocationToGridPoint(modelBounds.getMinX(), modelBounds.getMinY(), change.getDeltaX(), change.getDeltaY(), this.getViewer().getFeatures());
    }

    private final class MoveChange
    implements Change {
        private final FeedbackChange change;

        public MoveChange(FeedbackChange change) {
            this.change = change;
        }

        @Override
        public void applyChange() {
            MoveControllerBase.this.move(this.change);
        }
    }
}

