/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base;

import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ClickControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DragControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.MoveControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;

public abstract class ResizableContentControllerBase
extends MoveControllerBase {
    private IDragController defaultHorizontalResizeDragController = new DragControllerBase(){

        @Override
        public void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
            ResizableContentControllerBase.this.handleResizeDragInProgress(this.startBundle, delta.getX(), 0.0);
        }

        @Override
        public Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
            return ResizableContentControllerBase.this.handleResizeCompleted(this.startBundle, delta.getX(), 0.0);
        }
    };
    private IDragController defaultVerticalResizeController = new DragControllerBase(){

        @Override
        public void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
            ResizableContentControllerBase.this.handleResizeDragInProgress(this.startBundle, 0.0, delta.getY());
        }

        @Override
        public Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
            return ResizableContentControllerBase.this.handleResizeCompleted(this.startBundle, 0.0, delta.getY());
        }
    };
    private IDragController defaultHorizontalVerticalResizeDragController = new DragControllerBase(){

        @Override
        public void safeDragInProgress(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
            ResizableContentControllerBase.this.handleResizeDragInProgress(this.startBundle, delta.getX(), delta.getY());
        }

        @Override
        public Change safeDragCompleted(IMVCBundle bundle, Node node, DiagramCoordinate diagramLocation) {
            DiagramCoordinate delta = diagramLocation.subtract(this.startDiagramLocation);
            return ResizableContentControllerBase.this.handleResizeCompleted(this.startBundle, delta.getX(), delta.getY());
        }
    };

    public ResizableContentControllerBase(IContentMVCBundle mvcb) {
        super(mvcb);
    }

    @Override
    public IClickController getClickController(Node node, DiagramCoordinate diagramLocation) {
        IContentVisual visual = (IContentVisual)this.getVisual();
        if (this.allowExpandCollapse() && visual.isExpandCollapseWidget(node)) {
            return new ClickControllerBase(){

                @Override
                public Change singleClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
                    return () -> ResizableContentControllerBase.this.expandCollapse();
                }
            };
        }
        return super.getClickController(node, diagramLocation);
    }

    public boolean allowExpandCollapse() {
        return false;
    }

    public void expandCollapse() {
    }

    public boolean allowHorizontalResize() {
        return true;
    }

    public boolean allowVerticalResize() {
        return true;
    }

    protected boolean resizeChildren() {
        return true;
    }

    private void setResizeFeedbackChange(FeedbackChange change, IMVCBundle bundle) {
        bundle.setFeedbackChange(change);
        if (this.resizeChildren() && bundle instanceof IContentMVCBundle) {
            IContentMVCBundle cb = (IContentMVCBundle)bundle;
            for (IMVCBundle iMVCBundle : cb.getChildren()) {
                this.setResizeFeedbackChange(change, iMVCBundle);
            }
        }
    }

    protected Dimension2D getMinimumSize() {
        DiagramViewerFeatures features = this.getViewer().getFeatures();
        return new Dimension2D(features.getHorizontalSpacing(), features.getVerticalSpacing());
    }

    @Override
    public IDragController getDragController(EDragGesture gesture, Node n, DiagramCoordinate diagramLocation) {
        if (gesture == EDragGesture.RESIZE_H && this.allowHorizontalResize()) {
            return this.getHorizontalResizeDragController();
        }
        if (gesture == EDragGesture.RESIZE_V && this.allowVerticalResize()) {
            return this.getVerticalResizeDragController();
        }
        if (gesture == EDragGesture.RESIZE_VH && this.allowHorizontalResize() && this.allowVerticalResize()) {
            return this.getHorizontalVerticalResizeDragController();
        }
        return super.getDragController(gesture, n, diagramLocation);
    }

    public IDragController getHorizontalResizeDragController() {
        return this.defaultHorizontalResizeDragController;
    }

    private void handleResizeDragInProgress(IMVCBundle bundle, double dw, double dh) {
        FeedbackChange altered = this.alterResizeFeedback(FeedbackChange.sizeFeedbackChange(dw, dh));
        this.setResizeFeedbackChange(altered, bundle);
    }

    private Change handleResizeCompleted(IMVCBundle bundle, double dw, double dh) {
        bundle.setFeedbackChange(FeedbackChange.EMPTY);
        FeedbackChange altered = this.alterResizeFeedback(FeedbackChange.sizeFeedbackChange(dw, dh));
        if (altered.isEmpty()) {
            return null;
        }
        return () -> this.resize(altered);
    }

    protected boolean clampAndSnapResize() {
        return true;
    }

    protected FeedbackChange alterResizeFeedback(FeedbackChange change) {
        DiagramViewerFeatures features;
        IContentVisual visual = (IContentVisual)this.getMVCBundle().getVisual();
        Rectangle2D orig = visual.getModelBounds();
        double dw = change.getDeltaW();
        double dh = change.getDeltaH();
        Dimension2D minDim = this.getMinimumSize();
        double newMaxX = orig.getMinX() + Math.max(minDim.getWidth(), orig.getWidth() + dw);
        double newMaxY = orig.getMinY() + Math.max(minDim.getHeight(), orig.getHeight() + dh);
        if (this.clampAndSnapResize() && (features = this.getViewer().getFeatures()).useSnapToGrid()) {
            newMaxX = features.snapToGridX(newMaxX);
            newMaxY = features.snapToGridY(newMaxY);
        }
        return FeedbackChange.sizeFeedbackChange(newMaxX - orig.getMaxX(), newMaxY - orig.getMaxY());
    }

    public IDragController getVerticalResizeDragController() {
        return this.defaultVerticalResizeController;
    }

    public IDragController getHorizontalVerticalResizeDragController() {
        return this.defaultHorizontalVerticalResizeDragController;
    }

    protected void resize(FeedbackChange delta) {
    }

    @Override
    public Cursor getCurrentCursor(Node node, DiagramCoordinate diagramLocation) {
        EDragGesture edg = this.getVisual().getDragGesture(node, diagramLocation);
        switch (edg) {
            case RESIZE_H: {
                return this.allowHorizontalResize() ? Cursor.H_RESIZE : Cursor.DEFAULT;
            }
            case RESIZE_V: {
                return this.allowVerticalResize() ? Cursor.V_RESIZE : Cursor.DEFAULT;
            }
            case RESIZE_VH: {
                return this.allowHorizontalResize() && this.allowVerticalResize() ? Cursor.SE_RESIZE : Cursor.DEFAULT;
            }
        }
        return super.getCurrentCursor(node, diagramLocation);
    }
}

