/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.elliptic;

import javafx.geometry.Point2D;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.LinkControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;

public abstract class CurveLinkBendPointControllerBase
extends LinkControllerBase {
    public CurveLinkBendPointControllerBase(ILinkMVCBundle mvcb) {
        super(mvcb);
    }

    @Override
    protected final void moveBendPointVisually(int bpIndex, Point2D delta) {
        super.moveBendPointVisually(bpIndex, delta);
        if (bpIndex <= 0 || bpIndex >= this.getNumerOfBendPoints() - 1) {
            return;
        }
        ILinkVisual linkVisual = this.getLinkVisual();
        FeedbackChange centerPointChange = this.getMoveDeltaFeedback(bpIndex, delta);
        int indexMod3 = bpIndex % 3;
        if (indexMod3 == 2) {
            linkVisual.setFeedbackChangeForBendPoint(bpIndex - 1, centerPointChange);
            linkVisual.setFeedbackChangeForBendPoint(bpIndex + 1, centerPointChange);
        } else {
            FeedbackChange inv = FeedbackChange.locationFeedbackChange(-centerPointChange.getDeltaX(), -centerPointChange.getDeltaY());
            int otherIndex = indexMod3 == 1 ? bpIndex + 2 : bpIndex - 2;
            linkVisual.setFeedbackChangeForBendPoint(otherIndex, inv);
        }
    }

    @Override
    protected final void moveBendPointInModel(int bpIndex, Point2D delta) {
        FeedbackChange chg = this.getMoveDeltaFeedback(bpIndex, delta);
        this.getLinkVisual().setFeedbackChangeForBendPoint(bpIndex, null);
        this.updateModelAfterBendPointMove(bpIndex, chg.getDeltaX(), chg.getDeltaY());
        if (bpIndex <= 0 || bpIndex >= this.getNumerOfBendPoints() - 1) {
            return;
        }
        ILinkVisual linkVisual = this.getLinkVisual();
        int indexMod3 = bpIndex % 3;
        if (indexMod3 == 2) {
            linkVisual.setFeedbackChangeForBendPoint(bpIndex - 1, null);
            this.updateModelAfterBendPointMove(bpIndex - 1, chg.getDeltaX(), chg.getDeltaY());
            linkVisual.setFeedbackChangeForBendPoint(bpIndex + 1, null);
            this.updateModelAfterBendPointMove(bpIndex + 1, chg.getDeltaX(), chg.getDeltaY());
        } else {
            int otherIndex = indexMod3 == 1 ? bpIndex + 2 : bpIndex - 2;
            linkVisual.setFeedbackChangeForBendPoint(otherIndex, null);
            this.updateModelAfterBendPointMove(otherIndex, -chg.getDeltaX(), -chg.getDeltaY());
        }
    }

    @Override
    protected final void deleteBendPoint(int bpIndex) {
        if (bpIndex <= 0 || bpIndex >= this.getNumerOfBendPoints() - 1) {
            return;
        }
        int indexMod3 = bpIndex % 3;
        if (indexMod3 == 0) {
            this.deleteFromCurve(bpIndex - 2, bpIndex - 1, bpIndex);
        } else if (indexMod3 == 1) {
            this.deleteFromCurve(bpIndex, bpIndex + 1, bpIndex + 2);
        } else {
            this.deleteFromCurve(bpIndex - 1, bpIndex, bpIndex + 1);
        }
    }

    protected abstract void deleteFromCurve(int var1, int var2, int var3);

    @Override
    protected final void createBendPointAt(int bpIndex, DiagramCoordinate location) {
        DiagramViewerFeatures features = this.getViewer().getFeatures();
        DiagramCoordinate c2 = new DiagramCoordinate(location.getX() - 2.0 * features.getHorizontalSpacing(), location.getY());
        DiagramCoordinate c1 = new DiagramCoordinate(location.getX() + 2.0 * features.getHorizontalSpacing(), location.getY());
        this.createCurveSegment(bpIndex - 1, c2, location, c1);
    }

    protected abstract void createCurveSegment(int var1, DiagramCoordinate var2, DiagramCoordinate var3, DiagramCoordinate var4);
}

