/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.elliptic;

import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.AnchorageContentControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ContentAnchorageMoveControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic.EllipticBorderLocation;

public abstract class EllipticResizableContentControllerBase
extends AnchorageContentControllerBase {
    public EllipticResizableContentControllerBase(IContentMVCBundle mvcb) {
        super(mvcb);
    }

    @Override
    protected final IDragController createAnchorageMoveController(IContentAnchorageMVCBundle anchorage) {
        return new EllipticAnchorageMoveController(anchorage);
    }

    protected abstract void moveAnchorageToAngle(IContentAnchorageMVCBundle var1, double var2);

    private final class EllipticAnchorageMoveController
    extends ContentAnchorageMoveControllerBase {
        public EllipticAnchorageMoveController(IContentAnchorageMVCBundle anchorage) {
            super(anchorage);
        }

        private EllipticBorderLocation getBorderLocation(DiagramCoordinate delta) {
            Rectangle2D contentBounds = EllipticResizableContentControllerBase.this.getVisual().getModelBounds();
            Rectangle2D anchorageBounds = this.anchorage.getVisual().getModelBounds();
            Dimension2D span = new Dimension2D(anchorageBounds.getWidth(), anchorageBounds.getHeight());
            Point2D p = new Point2D(anchorageBounds.getMinX() + delta.getX(), anchorageBounds.getMinY() + delta.getY());
            EllipticBorderLocation rbl = EllipticBorderLocation.getClosestLocationOnBounds(p, contentBounds, span);
            return rbl;
        }

        @Override
        protected Point2D getAnchorageFeedbackLocation(DiagramCoordinate delta) {
            EllipticBorderLocation rbl = this.getBorderLocation(delta);
            return rbl.getLocation();
        }

        @Override
        protected void moveAnchorage(DiagramCoordinate delta) {
            EllipticBorderLocation rbl = this.getBorderLocation(delta);
            EllipticResizableContentControllerBase.this.moveAnchorageToAngle(this.anchorage, 360.0 - rbl.getAngleInDegree());
        }
    }
}

