/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.rectangular;

import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.AnchorageContentControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ContentAnchorageMoveControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;

public abstract class DiamondResizableContentControllerBase
extends AnchorageContentControllerBase {
    private static final double[] XCOORDS = new double[]{0.5, 0.5, 0.0, 1.0};
    private static final double[] YCOORDS = new double[]{0.0, 1.0, 0.5, 0.5};

    public DiamondResizableContentControllerBase(IContentMVCBundle mvcb) {
        super(mvcb);
    }

    private Side getClosestBorderLocation(double indicatorX, double indicatorY, Rectangle2D bounds) {
        Side resultSide = Side.values()[0];
        double hypo = Double.MAX_VALUE;
        double boundsX = bounds.getMinX();
        double boundsY = bounds.getMinY();
        int cur = 0;
        while (cur < XCOORDS.length) {
            double anchorageY;
            double anchorageX = boundsX + this.getXCoord(cur, bounds);
            double curHypo = Math.hypot(indicatorX - anchorageX, indicatorY - (anchorageY = boundsY + this.getYCoord(cur, bounds)));
            if (curHypo < hypo) {
                hypo = curHypo;
                resultSide = Side.values()[cur];
            }
            ++cur;
        }
        return resultSide;
    }

    private double getXCoord(int cur, Rectangle2D b) {
        return b.getWidth() * XCOORDS[cur];
    }

    private double getYCoord(int cur, Rectangle2D b) {
        return b.getHeight() * YCOORDS[cur];
    }

    @Override
    protected IDragController createAnchorageMoveController(IContentAnchorageMVCBundle anchorage) {
        return new ContentAnchorageMoveControllerBase(anchorage){

            @Override
            protected Point2D getAnchorageFeedbackLocation(DiagramCoordinate delta) {
                Rectangle2D cBounds = DiamondResizableContentControllerBase.this.getVisual().getModelBounds();
                Rectangle2D aBounds = this.anchorage.getVisual().getModelBounds();
                double indicatorX = cBounds.getMinX() + aBounds.getMinX() + delta.getX();
                double indicatorY = cBounds.getMinY() + aBounds.getMinY() + delta.getY();
                Side closest = DiamondResizableContentControllerBase.this.getClosestBorderLocation(indicatorX, indicatorY, cBounds);
                int idx = closest.ordinal();
                double x = cBounds.getWidth() * XCOORDS[idx] - aBounds.getWidth() / 2.0;
                double y = cBounds.getHeight() * YCOORDS[idx] - aBounds.getHeight() / 2.0;
                return new Point2D(x, y);
            }

            @Override
            protected void moveAnchorage(DiagramCoordinate delta) {
                Rectangle2D cBounds = DiamondResizableContentControllerBase.this.getVisual().getModelBounds();
                Rectangle2D aBounds = this.anchorage.getVisual().getModelBounds();
                double indicatorX = cBounds.getMinX() + aBounds.getMinX() + delta.getX();
                double indicatorY = cBounds.getMinY() + aBounds.getMinY() + delta.getY();
                DiamondResizableContentControllerBase.this.moveAnchorageToSideOffset(this.anchorage, DiamondResizableContentControllerBase.this.getClosestBorderLocation(indicatorX, indicatorY, cBounds), 0.0);
            }
        };
    }

    protected abstract void moveAnchorageToSideOffset(IContentAnchorageMVCBundle var1, Side var2, double var3);
}

