/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.rectangular;

import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ContentAnchorageMoveControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.rectangular.RectangularResizableContentControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularBorderLocation;

public class RectangularContentAnchorageMoveController
extends ContentAnchorageMoveControllerBase {
    private final RectangularResizableContentControllerBase contentController;

    public RectangularContentAnchorageMoveController(RectangularResizableContentControllerBase controller, IContentAnchorageMVCBundle anchorage) {
        super(anchorage);
        this.contentController = controller;
    }

    private RectangularBorderLocation getLocationOnBorder(IContentAnchorageMVCBundle anchorage, Point2D delta) {
        Rectangle2D contentBounds = this.contentController.getVisual().getModelBounds();
        Rectangle2D anchorageBounds = anchorage.getVisual().getModelBounds();
        Dimension2D anchorageSize = new Dimension2D(anchorageBounds.getWidth(), anchorageBounds.getHeight());
        Dimension2D borderSnap = this.overrideBorderSnap(anchorageSize);
        DiagramCoordinate p = new DiagramCoordinate(anchorageBounds.getMinX() + anchorageSize.getWidth() / 2.0 + delta.getX(), anchorageBounds.getMinY() + anchorageSize.getHeight() / 2.0 + delta.getY());
        return RectangularBorderLocation.getClosestLocationOnBounds(p, contentBounds, anchorageSize, borderSnap);
    }

    protected Dimension2D overrideBorderSnap(Dimension2D anchorageBounds) {
        return anchorageBounds;
    }

    @Override
    protected Point2D getAnchorageFeedbackLocation(DiagramCoordinate delta) {
        RectangularBorderLocation rbl = this.getLocationOnBorder(this.anchorage, delta);
        return rbl.getLocation();
    }

    @Override
    protected void moveAnchorage(DiagramCoordinate delta) {
        RectangularBorderLocation rbl = this.getLocationOnBorder(this.anchorage, delta);
        this.contentController.moveAnchorageToSideOffset(this.anchorage, rbl.getSide(), rbl.getOffset());
    }
}

