/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.controller.rectangular;

import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ContentAnchorageMoveControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.rectangular.RhomboidResizableContentControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularBorderLocation;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RhomboidContentVisualBase;

public class RhomboidContentAnchorageMoveController
extends ContentAnchorageMoveControllerBase {
    private final RhomboidResizableContentControllerBase contentController;

    public RhomboidContentAnchorageMoveController(RhomboidResizableContentControllerBase controller, IContentAnchorageMVCBundle anchorage) {
        super(anchorage);
        this.contentController = controller;
        if (!(this.contentController.getVisual() instanceof RhomboidContentVisualBase)) {
            throw new IllegalArgumentException("Expected RhomboidContentVisualBase.");
        }
    }

    private Pair<Side, Double> getLocationOnBorder(IContentAnchorageMVCBundle anchorage, Point2D delta) {
        double rx;
        double rightHypo;
        IContentAnchorageVisual anchorageVisual = anchorage.getVisual();
        Rectangle2D anchorageBounds = anchorageVisual.getModelBounds();
        double awidth = anchorageBounds.getWidth();
        double aheight = anchorageBounds.getHeight();
        IVisual contentVisual = this.contentController.getVisual();
        Rectangle2D contentBounds = contentVisual.getModelBounds();
        double rhomboidOffset = ((RhomboidContentVisualBase)contentVisual).getOffset();
        double topX = contentBounds.getMinX();
        double indicatorX = topX + rhomboidOffset + delta.getX() + awidth / 2.0;
        double widthLessOffset = contentBounds.getWidth() - rhomboidOffset;
        double topY = contentBounds.getMinY();
        double indicatorY = topY + delta.getY() + aheight / 2.0;
        double botY = contentBounds.getMaxY();
        Side resultSide = Side.TOP;
        double resultOffset = rhomboidOffset;
        double hypo = Double.MAX_VALUE;
        double fx = 0.0;
        while (fx <= 1.0) {
            double bx;
            double botHypo;
            double tx = topX + rhomboidOffset + fx * widthLessOffset;
            double topHypo = Math.hypot(indicatorX - tx, indicatorY - topY);
            if (topHypo < hypo) {
                hypo = topHypo;
                resultOffset = tx - topX;
                resultSide = Side.TOP;
            }
            if ((botHypo = Math.hypot(indicatorX - (bx = topX + fx * widthLessOffset), indicatorY - botY)) < hypo) {
                hypo = botHypo;
                resultOffset = bx - topX;
                resultSide = Side.BOTTOM;
            }
            fx += 0.25;
        }
        double lx = topX + rhomboidOffset / 2.0;
        double height2 = contentBounds.getHeight() / 2.0;
        double halfHeightY = topY + height2;
        double leftHypo = Math.hypot(indicatorX - lx, indicatorY - halfHeightY);
        if (leftHypo < hypo) {
            hypo = leftHypo;
            resultOffset = height2;
            resultSide = Side.LEFT;
        }
        if ((rightHypo = Math.hypot(indicatorX - (rx = topX + contentBounds.getWidth() - rhomboidOffset / 2.0), indicatorY - halfHeightY)) < hypo) {
            resultOffset = height2;
            resultSide = Side.RIGHT;
        }
        return new ImmutablePair((Object)resultSide, (Object)(resultOffset - awidth / 2.0));
    }

    protected Dimension2D overrideBorderSnap(Dimension2D anchorageBounds) {
        return anchorageBounds;
    }

    @Override
    protected Point2D getAnchorageFeedbackLocation(DiagramCoordinate delta) {
        RhomboidContentVisualBase contentVisual = (RhomboidContentVisualBase)this.contentController.getVisual();
        Rectangle2D contentBounds = contentVisual.getModelBounds();
        Rectangle2D anchorageBounds = this.anchorage.getVisual().getModelBounds();
        Dimension2D anchorageSize = new Dimension2D(anchorageBounds.getWidth(), anchorageBounds.getHeight());
        double rhomboidOffset = contentVisual.getOffset();
        Pair<Side, Double> lob = this.getLocationOnBorder(this.anchorage, delta);
        Side side = (Side)lob.getLeft();
        if (side == Side.LEFT) {
            double lx = rhomboidOffset / 2.0 - anchorageSize.getWidth() / 2.0;
            double ly = (contentBounds.getHeight() - anchorageSize.getHeight()) / 2.0;
            return new DiagramCoordinate(lx, ly);
        }
        if (side == Side.RIGHT) {
            double lx = contentBounds.getWidth() - (rhomboidOffset + anchorageSize.getWidth()) / 2.0;
            double ly = (contentBounds.getHeight() - anchorageSize.getHeight()) / 2.0;
            return new DiagramCoordinate(lx, ly);
        }
        RectangularBorderLocation rbl = new RectangularBorderLocation(side, (Double)lob.getRight(), contentBounds, anchorageSize);
        return rbl.getLocation();
    }

    @Override
    protected void moveAnchorage(DiagramCoordinate delta) {
        Pair<Side, Double> lob = this.getLocationOnBorder(this.anchorage, delta);
        this.contentController.moveAnchorageToSideOffset(this.anchorage, (Side)lob.getLeft(), (Double)lob.getRight());
    }
}

