/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.model;

import java.util.ArrayList;
import java.util.List;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeListener;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeProvider;

public abstract class ModelChangeProviderBase
implements IModelChangeProvider {
    private final List<IModelChangeListener> listeners = new ArrayList<IModelChangeListener>();

    @Override
    public void addListener(IModelChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
            this.connectToModel();
        }
    }

    protected void connectToModel() {
    }

    @Override
    public void removeListener(IModelChangeListener l) {
        this.listeners.remove(l);
        if (this.listeners.isEmpty()) {
            this.disconnectFromModel();
        }
    }

    protected void disconnectFromModel() {
    }

    @Override
    public void fireUpdateComplete() {
        ArrayList<IModelChangeListener> iterationSafeCopy = new ArrayList<IModelChangeListener>(this.listeners);
        for (IModelChangeListener l : iterationSafeCopy) {
            l.changed(this);
        }
    }
}

