/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeListener;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeProvider;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.MVCBundleTag;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisual;

public abstract class MVCBundleBase
implements IModelChangeListener,
IMVCBundle {
    private final Object model;
    private final DiagramViewer viewer;
    private IVisual visual;
    private IController controller;
    private FeedbackChange feedbackChange = new FeedbackChange();
    private final Map<String, MVCBundleTag> tagMap = new HashMap<String, MVCBundleTag>();

    public MVCBundleBase(Object m, DiagramViewer v) {
        this.model = Objects.requireNonNull(m, "Model must not be null.");
        this.viewer = Objects.requireNonNull(v, "Viewer must not be null.");
    }

    @Override
    public final void setVisual(IVisual visual) {
        this.visual = Objects.requireNonNull(visual, "Visual must not be null.");
    }

    @Override
    public void attach() {
        IModelChangeProvider adapted;
        IModelChangeProvider mcp;
        if (this.model instanceof IModelChangeProvider) {
            mcp = (IModelChangeProvider)this.model;
            mcp.addListener(this);
        }
        if (this.controller instanceof IModelChangeProvider) {
            mcp = (IModelChangeProvider)((Object)this.controller);
            mcp.addListener(this);
        }
        if ((adapted = this.controller.getModelChangeProvider()) != null) {
            adapted.addListener(this);
        }
    }

    @Override
    public final void detach() {
        IModelChangeProvider adapted;
        IModelChangeProvider mcp;
        if (this.model instanceof IModelChangeProvider) {
            mcp = (IModelChangeProvider)this.model;
            mcp.removeListener(this);
        }
        if (this.controller instanceof IModelChangeProvider) {
            mcp = (IModelChangeProvider)((Object)this.controller);
            mcp.removeListener(this);
        }
        if ((adapted = this.controller.getModelChangeProvider()) != null) {
            adapted.removeListener(this);
        }
    }

    @Override
    public final void setController(IController controller) {
        this.controller = Objects.requireNonNull(controller, "Controller must not be null.");
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    @Override
    public IVisual getVisual() {
        return this.visual;
    }

    @Override
    public IController getController() {
        return this.controller;
    }

    @Override
    public DiagramViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void changed(Object element) {
        this.viewer.updateFromModel();
    }

    @Override
    public final void setFeedbackChange(FeedbackChange feedbackChange) {
        this.feedbackChange = Objects.requireNonNull(feedbackChange);
        this.viewer.updateVisual(this);
    }

    @Override
    public final FeedbackChange getFeedbackChange() {
        return this.feedbackChange;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " MVC bundle of " + this.getModel().toString();
    }

    @Override
    public void addTag(MVCBundleTag tag) {
        this.tagMap.put(tag.getTagIdentifier(), tag);
    }

    @Override
    public MVCBundleTag getTag(MVCBundleTag tag) {
        return this.tagMap.get(tag.getTagIdentifier());
    }

    @Override
    public boolean hasTag(MVCBundleTag tag) {
        if (tag == null) {
            return false;
        }
        return this.tagMap.get(tag.getTagIdentifier()) != null;
    }

    @Override
    public void removeTag(MVCBundleTag tag) {
        this.tagMap.remove(tag.getTagIdentifier());
    }
}

