/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base;

import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.VisualBase;

public abstract class ContentAnchorageVisualBase
extends VisualBase
implements IContentAnchorageVisual {
    public ContentAnchorageVisualBase(IContentAnchorageMVCBundle mvcb, Shape visual, Shape hit) {
        super(mvcb, visual, hit);
    }

    @Override
    public IContentAnchorageMVCBundle getMVCBundle() {
        return (IContentAnchorageMVCBundle)super.getMVCBundle();
    }

    @Override
    protected DiagramLayers.ILayer getLayerForVisualShape(DiagramLayers layers) {
        return layers.getAnchorageLayer();
    }

    @Override
    protected DiagramLayers.ILayer getLayerForHitShape(DiagramLayers layers) {
        return layers.getAnchorageInteractionLayer();
    }

    protected Point2D getLocationOnParent() {
        IContentVisual cv = this.getMVCBundle().getAttachedTo().getVisual();
        return cv.getAnchorageLocation(this);
    }

    @Override
    public Rectangle2D getCurrentBounds() {
        Rectangle2D parentBounds = this.getMVCBundle().getAttachedTo().getVisual().getCurrentBounds();
        Point2D modelLocationOnParent = this.getLocationOnParent();
        Dimension2D size = this.getDimensions();
        FeedbackChange chg = this.getFeedbackChange();
        double x = parentBounds.getMinX() + modelLocationOnParent.getX() + chg.getDeltaX();
        double y = parentBounds.getMinY() + modelLocationOnParent.getY() + chg.getDeltaY();
        return new Rectangle2D(x, y, size.getWidth(), size.getHeight());
    }

    @Override
    public Dimension2D getDimensions() {
        DiagramViewerFeatures features = this.getViewer().getFeatures();
        return new Dimension2D(features.getHorizontalSpacing(), features.getVerticalSpacing());
    }

    protected Paint getHighlightIncomingLinkColor() {
        return Color.GREENYELLOW;
    }

    protected Paint getHighlightOutgoingLinkColor() {
        return Color.TOMATO;
    }

    protected Paint getHighlightIncomingLinkBorderColor() {
        return Color.GREENYELLOW.darker();
    }

    protected Paint getHighlightOutgoingLinkBorderColor() {
        return Color.TOMATO.darker();
    }

    @Override
    public boolean updateSiblingAnchorageVisualsOnHover() {
        return false;
    }
}

