/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base;

import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.MVCBundleTag;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.VisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.widgets.ExpandCollapseWidget;

public abstract class ContentVisualBase
extends VisualBase
implements IContentVisual {
    protected final Text text = new Text();
    protected final ImageView icon = new ImageView();
    protected final ExpandCollapseWidget expandCollapseWidget = new ExpandCollapseWidget(0.0, 0.0, 20.0, 20.0, 3.0);

    public ContentVisualBase(IContentMVCBundle mvcb, Shape visual, Shape hit) {
        super(mvcb, visual, hit);
    }

    protected boolean enableIcon() {
        return true;
    }

    protected boolean enableText() {
        return true;
    }

    protected boolean enableExpandCollapseWidget() {
        return false;
    }

    protected String getName() {
        return "";
    }

    protected Paint getTextColor() {
        return Color.BLACK;
    }

    protected DiagramCoordinate getTextAnchorLocation() {
        Insets i = this.getTextInsets();
        double croppedHeight = this.getCurrentBounds().getHeight() - i.getTop() - i.getBottom();
        return new DiagramCoordinate(0.0, croppedHeight / 2.0);
    }

    protected Insets getTextInsets() {
        return new Insets(10.0, 10.0, 10.0, 10.0);
    }

    protected VPos getVerticalTextAlignment() {
        return VPos.CENTER;
    }

    protected TextAlignment getHorizontalTextAlignment() {
        return TextAlignment.LEFT;
    }

    protected Image getIcon() {
        return null;
    }

    @Override
    public final void applySelectedFocusedEffect(DiagramLayers layers) {
        super.applySelectedFocusedEffect(layers);
        if (this.getViewer().getFeatures().isLinkHighlightingEnabled()) {
            IContentMVCBundle bundle = this.getMVCBundle();
            List<IContentAnchorageMVCBundle> anchoragesBundles = bundle.getAnchorages();
            for (IContentAnchorageMVCBundle aBundle : anchoragesBundles) {
                List<ILinkMVCBundle> incomingLinksBundles = aBundle.getIncomingLinks();
                for (ILinkMVCBundle ilBundle : incomingLinksBundles) {
                    this.addTag(ilBundle, DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG, layers);
                    this.addTag(ilBundle.getStartAnchorage(), DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG, layers);
                    this.addTag(ilBundle.getEndAnchorage(), DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG, layers);
                }
                List<ILinkMVCBundle> outgoingLinksBundles = aBundle.getOutgoingLinks();
                for (ILinkMVCBundle olBundle : outgoingLinksBundles) {
                    this.addTag(olBundle, DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG, layers);
                    this.addTag(olBundle.getEndAnchorage(), DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG, layers);
                    this.addTag(olBundle.getStartAnchorage(), DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG, layers);
                }
            }
        }
    }

    @Override
    protected void applyNotSelectedEffect(DiagramLayers layers) {
        super.applyNotSelectedEffect(layers);
        IContentMVCBundle bundle = this.getMVCBundle();
        List<IContentAnchorageMVCBundle> anchoragesBundles = bundle.getAnchorages();
        for (IContentAnchorageMVCBundle aBundle : anchoragesBundles) {
            List<ILinkMVCBundle> incomingLinksBundles = aBundle.getIncomingLinks();
            for (ILinkMVCBundle ilBundle : incomingLinksBundles) {
                this.removeTag(ilBundle, DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG, layers);
                this.removeTag(ilBundle.getStartAnchorage(), DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG, layers);
                this.removeTag(ilBundle.getEndAnchorage(), DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG, layers);
            }
            List<ILinkMVCBundle> outgoingLinksBundles = aBundle.getOutgoingLinks();
            for (ILinkMVCBundle olBundle : outgoingLinksBundles) {
                this.removeTag(olBundle, DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG, layers);
                this.removeTag(olBundle.getEndAnchorage(), DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG, layers);
                this.removeTag(olBundle.getStartAnchorage(), DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG, layers);
            }
        }
    }

    @Override
    public Rectangle2D getCurrentBounds() {
        FeedbackChange fb = this.getFeedbackChange();
        Rectangle2D mb = this.getModelBounds();
        return fb.applyTo(mb);
    }

    private void addTag(IMVCBundle bundle, MVCBundleTag tag, DiagramLayers layers) {
        bundle.addTag(tag);
        bundle.getVisual().updateNodes(layers);
    }

    private void removeTag(IMVCBundle bundle, MVCBundleTag tag, DiagramLayers layers) {
        bundle.removeTag(tag);
        bundle.getVisual().updateNodes(layers);
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        IContentMVCBundle bundle = this.getMVCBundle();
        Rectangle2D bounds = this.getCurrentBounds();
        double leftX = bounds.getMinX();
        double rightX = bounds.getMaxX();
        double upperY = bounds.getMinY();
        Insets i = this.getTextInsets();
        DiagramCoordinate anchorLocation = this.getTextAnchorLocation();
        double anchorX = leftX + anchorLocation.getX() + i.getLeft();
        double anchorY = upperY + anchorLocation.getY() + i.getTop();
        if (this.enableIcon()) {
            if (this.icon.getParent() == null) {
                layers.getTextLayer().add((Node)this.icon, bundle);
            }
            Image img = this.getIcon();
            this.icon.setImage(img);
            if (img != null) {
                this.icon.setX(anchorX);
                anchorX += img.getWidth() + i.getLeft();
                this.icon.setY(anchorY - img.getHeight() / 2.0);
            }
        } else {
            layers.getTextLayer().remove((Node)this.icon);
        }
        if (this.enableText()) {
            if (this.text.getParent() == null) {
                layers.getTextLayer().add((Node)this.text, bundle);
            }
            this.text.setX(anchorX);
            this.text.setY(anchorY);
            this.text.setFill(this.getTextColor());
            this.text.setText(this.getName());
            this.text.setWrappingWidth(rightX - anchorX - i.getRight());
            this.text.setTextAlignment(this.getHorizontalTextAlignment());
            this.text.setTextOrigin(this.getVerticalTextAlignment());
        } else {
            layers.getTextLayer().remove((Node)this.text);
        }
        if (this.enableExpandCollapseWidget()) {
            if (this.expandCollapseWidget.getParent() == null) {
                layers.getContentInteractionLayer().add((Node)this.expandCollapseWidget, bundle);
            }
            Rectangle2D ecWidgetLocation = this.getExpandCollapseWidgetRectangle();
            double inset = this.getExpandCollapseWidgetInset();
            double x = leftX + ecWidgetLocation.getMinX();
            double y = upperY + ecWidgetLocation.getMinY();
            this.expandCollapseWidget.update(x, y, ecWidgetLocation.getWidth(), ecWidgetLocation.getHeight(), inset);
            this.expandCollapseWidget.setState(this.getExpandCollapseWidgetState());
        } else {
            layers.getContentInteractionLayer().remove((Node)this.expandCollapseWidget);
        }
    }

    @Override
    public void removeAllVisuals(DiagramLayers layers) {
        super.removeAllVisuals(layers);
        layers.getContentInteractionLayer().remove((Node)this.expandCollapseWidget);
        layers.getTextLayer().remove((Node)this.text);
        layers.getTextLayer().remove((Node)this.icon);
    }

    protected boolean getExpandCollapseWidgetState() {
        return true;
    }

    protected double getExpandCollapseWidgetInset() {
        return 3.0;
    }

    protected Rectangle2D getExpandCollapseWidgetRectangle() {
        Rectangle2D b = this.getCurrentBounds();
        return new Rectangle2D(b.getWidth() - 20.0, 6.0, 14.0, 14.0);
    }

    @Override
    public IContentMVCBundle getMVCBundle() {
        return (IContentMVCBundle)super.getMVCBundle();
    }

    @Override
    public boolean isExpandCollapseWidget(Node widget) {
        return this.expandCollapseWidget.isHit(widget);
    }

    @Override
    public boolean updateAttachedAnchorageVisualsOnHover() {
        return false;
    }
}

