/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base;

import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.MVCBundlePartWithEffectsBase;

public abstract class LinkVisualBase
extends MVCBundlePartWithEffectsBase
implements ILinkVisual {
    protected final Map<Integer, FeedbackChange> feedbackChanges = new HashMap<Integer, FeedbackChange>();
    protected final Rectangle startFeedbackHandle;
    protected final Rectangle endFeedbackHandle;
    private static final Color INTERACTION_SHADING = Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.1);

    public LinkVisualBase(ILinkMVCBundle mvcb) {
        super(mvcb);
        double feedbackSize = this.getFeedbackMarkerSize();
        double fs2 = feedbackSize / 2.0;
        DiagramCoordinate startAnchorPoint = this.getStartAnchorPoint();
        this.startFeedbackHandle = new Rectangle(startAnchorPoint.getX() - fs2, startAnchorPoint.getY() - fs2, feedbackSize, feedbackSize);
        this.startFeedbackHandle.setFill((Paint)Color.TRANSPARENT);
        this.startFeedbackHandle.setStroke((Paint)Color.RED);
        DiagramCoordinate endAnchorPoint = this.getEndAnchorPoint();
        this.endFeedbackHandle = new Rectangle(endAnchorPoint.getX() - fs2, endAnchorPoint.getY() - fs2, feedbackSize, feedbackSize);
        this.endFeedbackHandle.setFill((Paint)Color.TRANSPARENT);
        this.endFeedbackHandle.setStroke((Paint)Color.RED);
    }

    @Override
    public final Rectangle2D getModelBounds() {
        return null;
    }

    @Override
    public void setFeedbackChangeForBendPoint(int index, FeedbackChange change) {
        if (change == null) {
            this.feedbackChanges.remove(index);
        } else {
            this.feedbackChanges.put(index, change);
        }
        this.getViewer().updateVisual(this.getMVCBundle());
    }

    protected FeedbackChange getFeedbackChangeForBendPoint(int index) {
        FeedbackChange result = this.feedbackChanges.get(index);
        if (result == null) {
            return FeedbackChange.EMPTY;
        }
        return result;
    }

    @Override
    public DiagramCoordinate getLinkAnchorage(DiagramCoordinate indication) {
        return indication;
    }

    protected Paint getHighlightIncomingLinkColor() {
        return Color.GREENYELLOW;
    }

    protected Paint getHighlightOutgoingLinkColor() {
        return Color.TOMATO;
    }

    protected DiagramCoordinate getCircleLocation(Rectangle2D bounds, Point2D target) {
        double sx = bounds.getMinX() + bounds.getWidth() / 2.0;
        double sy = bounds.getMinY() + bounds.getHeight() / 2.0;
        double a = Math.atan2(target.getY() - sy, target.getX() - sx);
        double nx = sx + Math.cos(a) * (bounds.getWidth() / 2.0 - 1.0);
        double ny = sy + Math.sin(a) * (bounds.getHeight() / 2.0 - 1.0);
        return new DiagramCoordinate(nx, ny);
    }

    protected final DiagramCoordinate getRectangleLocation(Rectangle2D ib, Point2D target) {
        double cx = ib.getMinX() + ib.getWidth() / 2.0;
        double cy = ib.getMinY() + ib.getHeight() / 2.0;
        double dx = cx - target.getX();
        double dy = cy - target.getY();
        if (Math.abs(dx) > Math.abs(dy)) {
            if (cx < target.getX()) {
                return new DiagramCoordinate(ib.getMaxX(), cy);
            }
            return new DiagramCoordinate(ib.getMinX(), cy);
        }
        if (cy < target.getY()) {
            return new DiagramCoordinate(cx, ib.getMaxY());
        }
        return new DiagramCoordinate(cx, ib.getMinY());
    }

    protected final Paint getInteractionColor() {
        return this.getViewer().getFeatures().isInteractionAreaShadingEnabled() ? INTERACTION_SHADING : Color.TRANSPARENT;
    }

    protected double getFeedbackMarkerSize() {
        return this.getMVCBundle().getViewer().getFeatures().getHorizontalSpacing() / 2.0;
    }

    @Override
    public int getBendPointIndex(Node node) {
        if (node == this.startFeedbackHandle) {
            return Integer.MIN_VALUE;
        }
        if (node == this.endFeedbackHandle) {
            return -2147483647;
        }
        return -2147483646;
    }

    @Override
    public boolean isBendPointHandle(Node node) {
        return node == this.startFeedbackHandle || node == this.endFeedbackHandle;
    }

    @Override
    public void disableFeedback() {
        this.startFeedbackHandle.setMouseTransparent(true);
        this.endFeedbackHandle.setMouseTransparent(true);
    }

    @Override
    public void enableFeedback() {
        this.startFeedbackHandle.setMouseTransparent(false);
        this.endFeedbackHandle.setMouseTransparent(false);
    }
}

