/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base;

import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.MVCBundlePartBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisual;

public abstract class MVCBundlePartWithEffectsBase
extends MVCBundlePartBase
implements IVisual {
    public MVCBundlePartWithEffectsBase(IMVCBundle mvcb) {
        super(mvcb);
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        IMVCBundle bundle = this.getMVCBundle();
        if (bundle.hasTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG)) {
            if (bundle.hasTag(DiagramViewerDefaultTags.FOCUS_TAG)) {
                this.applySelectedFocusedEffect(layers);
            } else {
                this.applySelectedNotFocusedEffect(layers);
            }
        } else if (bundle.hasTag(DiagramViewerDefaultTags.SECONDARY_SELECTION_TAG)) {
            this.applySecondarySelectedEffect(layers);
        } else {
            this.applyNotSelectedEffect(layers);
        }
        if (bundle.hasTag(DiagramViewerDefaultTags.HOVER_TAG)) {
            this.createHoverEffect(layers);
        } else {
            this.removeHoverEffect(layers);
        }
        if (bundle.hasTag(DiagramViewerDefaultTags.LINK_TARGET_ALLOWED_TAG)) {
            this.createLinkTargetAllowedEffect(layers);
        } else if (bundle.hasTag(DiagramViewerDefaultTags.LINK_TARGET_DENIED_TAG)) {
            this.createLinkTargetDeniedEffect(layers);
        } else if (bundle.hasTag(DiagramViewerDefaultTags.LINK_TARGET_MAYBE_TAG)) {
            this.createLinkTargetMaybeEffect(layers);
        } else {
            this.createLinkTargetDisabledEffect(layers);
        }
    }

    @Override
    public void removeAllVisuals(DiagramLayers layers) {
        this.applyNotSelectedEffect(layers);
        this.removeHoverEffect(layers);
        this.createLinkTargetDisabledEffect(layers);
    }

    protected void applyNotSelectedEffect(DiagramLayers layers) {
    }

    protected void applySelectedFocusedEffect(DiagramLayers layers) {
    }

    protected void applySelectedNotFocusedEffect(DiagramLayers layers) {
    }

    protected void applySecondarySelectedEffect(DiagramLayers layers) {
    }

    protected void createHoverEffect(DiagramLayers layers) {
    }

    protected void removeHoverEffect(DiagramLayers layers) {
    }

    protected void createLinkTargetAllowedEffect(DiagramLayers layers) {
    }

    protected void createLinkTargetDeniedEffect(DiagramLayers layers) {
    }

    protected void createLinkTargetMaybeEffect(DiagramLayers layers) {
    }

    protected void createLinkTargetDisabledEffect(DiagramLayers layers) {
    }
}

