/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base;

import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.MVCBundlePartWithEffectsBase;

public abstract class VisualBase
extends MVCBundlePartWithEffectsBase
implements IVisual {
    private static final double DEFAULT_DROP_SHADOW_RAIDUS = 10.0;
    private static final double DEFAULT_DROP_SHADOW_OFFSET = 3.0;
    private final Shape visualShape;
    private final Shape hitAreaShape;
    protected final Rectangle selectionRectangle = new Rectangle();
    private final Text hoverText = new Text("");
    protected static final Color INTERACTION_SHADING = Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.1);

    public VisualBase(IMVCBundle mvcb, Shape visual, Shape hit) {
        super(mvcb);
        this.visualShape = visual;
        this.hitAreaShape = hit;
        this.hitAreaShape.setFill((Paint)Color.TRANSPARENT);
        this.hitAreaShape.setStroke((Paint)Color.TRANSPARENT);
        this.selectionRectangle.setFill((Paint)Color.TRANSPARENT);
        this.selectionRectangle.setStrokeWidth(2.0);
        this.hoverText.setMouseTransparent(true);
    }

    protected final Shape getHitAreaShape() {
        return this.hitAreaShape;
    }

    protected final Shape getVisualShape() {
        return this.visualShape;
    }

    @Override
    protected void createHoverEffect(DiagramLayers layers) {
        String text;
        Color shadow = this.getHoverShadowColor();
        if (shadow != null && this.visualShape != null) {
            this.visualShape.setEffect((Effect)new DropShadow(10.0, 3.0, 3.0, shadow));
        }
        if ((text = this.getHoverText()) == null) {
            return;
        }
        this.hoverText.setText(text);
        Point2D loc = this.getHoverTextLocation();
        Rectangle2D bounds = this.getCurrentBounds();
        double tx = bounds.getMinX() + loc.getX();
        this.hoverText.setX(tx);
        double ty = bounds.getMinY() + loc.getY();
        this.hoverText.setY(ty);
        this.hoverText.setTextAlignment(TextAlignment.LEFT);
        this.hoverText.setTextOrigin(VPos.TOP);
        this.hoverText.setMouseTransparent(true);
        layers.getVisualFeedbackLayer().add((Node)this.hoverText, this.getMVCBundle());
    }

    @Override
    protected void removeHoverEffect(DiagramLayers layers) {
        if (this.visualShape != null) {
            this.visualShape.setEffect(null);
        }
        layers.getVisualFeedbackLayer().remove((Node)this.hoverText);
    }

    @Override
    public void removeAllVisuals(DiagramLayers layers) {
        super.removeAllVisuals(layers);
        this.getLayerForHitShape(layers).remove((Node)this.hitAreaShape);
        this.getLayerForVisualShape(layers).remove((Node)this.visualShape);
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        IMVCBundle bundle = this.getMVCBundle();
        if (this.visualShape != null) {
            if (this.enableVisual()) {
                if (this.visualShape.getParent() == null) {
                    this.getLayerForVisualShape(layers).add((Node)this.visualShape, bundle);
                }
            } else {
                this.getLayerForVisualShape(layers).remove((Node)this.visualShape);
            }
        }
        if (this.hitAreaShape != null) {
            if (this.enableInteraction()) {
                if (this.hitAreaShape.getParent() == null) {
                    this.getLayerForHitShape(layers).add((Node)this.hitAreaShape, bundle);
                }
            } else {
                this.getLayerForHitShape(layers).remove((Node)this.hitAreaShape);
            }
        }
    }

    protected DiagramLayers.ILayer getLayerForVisualShape(DiagramLayers layers) {
        return layers.getContentLayer();
    }

    protected DiagramLayers.ILayer getLayerForHitShape(DiagramLayers layers) {
        return layers.getContentInteractionLayer();
    }

    @Override
    public boolean enableVisual() {
        return true;
    }

    @Override
    public boolean enableInteraction() {
        return true;
    }

    protected void updateSelectionFeedbackRectangle(Paint color, DiagramLayers layers) {
        Rectangle2D bounds = this.getCurrentBounds();
        if (bounds == null) {
            return;
        }
        this.selectionRectangle.setX(bounds.getMinX());
        this.selectionRectangle.setY(bounds.getMinY());
        this.selectionRectangle.setWidth(bounds.getWidth());
        this.selectionRectangle.setHeight(bounds.getHeight());
        this.selectionRectangle.setStroke(color);
        layers.getVisualFeedbackLayer().add((Node)this.selectionRectangle, this.getMVCBundle());
    }

    @Override
    protected void applySelectedNotFocusedEffect(DiagramLayers layers) {
        this.updateSelectionFeedbackRectangle((Paint)this.getSelectedNotFocusedColor(), layers);
    }

    @Override
    protected void applySecondarySelectedEffect(DiagramLayers layers) {
        this.updateSelectionFeedbackRectangle((Paint)this.getSecondarySelectedColor(), layers);
    }

    @Override
    protected void applySelectedFocusedEffect(DiagramLayers layers) {
        this.updateSelectionFeedbackRectangle((Paint)this.getSelectedFocusedColor(), layers);
    }

    @Override
    protected void applyNotSelectedEffect(DiagramLayers layers) {
        super.applyNotSelectedEffect(layers);
        layers.getVisualFeedbackLayer().remove((Node)this.selectionRectangle);
    }

    @Override
    public EDragGesture getDragGesture(Node node, DiagramCoordinate diagramLocation) {
        boolean notSelected = !this.getViewer().isPrimarySelected(this.getMVCBundle());
        EDragGesture gesture = this.dragGestureHitTest(node, diagramLocation);
        if (gesture == EDragGesture.NEW_LINK && this.requireSelectionForNewLinkGesture() && notSelected) {
            return EDragGesture.NONE;
        }
        if (gesture == EDragGesture.MOVE && this.requireSelectionForMoveGesture() && notSelected) {
            return EDragGesture.NONE;
        }
        if ((gesture == EDragGesture.RESIZE_H || gesture == EDragGesture.RESIZE_V || gesture == EDragGesture.RESIZE_VH) && this.requireSelectionForResizeGesture() && notSelected) {
            return EDragGesture.NONE;
        }
        return gesture;
    }

    protected EDragGesture dragGestureHitTest(Node node, DiagramCoordinate diagramLocation) {
        return EDragGesture.NONE;
    }

    protected boolean requireSelectionForNewLinkGesture() {
        return false;
    }

    protected boolean requireSelectionForMoveGesture() {
        return true;
    }

    protected boolean requireSelectionForResizeGesture() {
        return true;
    }

    protected double getOpacity() {
        return 0.8;
    }

    protected Paint getBorderColor() {
        return Color.CORNFLOWERBLUE;
    }

    protected double getBorderWidth() {
        return 2.0;
    }

    protected StrokeType getBorderType() {
        return StrokeType.INSIDE;
    }

    protected Paint getFillColor() {
        return Color.DEEPSKYBLUE;
    }

    protected Color getSelectedFocusedColor() {
        return Color.RED;
    }

    protected Color getSecondarySelectedColor() {
        return Color.ORANGE;
    }

    protected Color getSelectedNotFocusedColor() {
        return Color.RED;
    }

    protected double getHitAreaOutset() {
        return 10.0;
    }

    protected Color getInteractionColor() {
        return this.getViewer().getFeatures().isInteractionAreaShadingEnabled() ? INTERACTION_SHADING : Color.TRANSPARENT;
    }

    protected Color getHoverShadowColor() {
        return Color.DARKGRAY.darker();
    }

    protected String getHoverText() {
        return null;
    }

    protected Point2D getHoverTextLocation() {
        return new Point2D(0.0, this.getCurrentBounds().getHeight());
    }

    protected final DiagramCoordinate getCurrentBoundsCenter() {
        Rectangle2D b = this.getVisual().getCurrentBounds();
        double x = b.getMinX() + b.getWidth() / 2.0;
        double y = b.getMinY() + b.getHeight() / 2.0;
        return new DiagramCoordinate(x, y);
    }

    @Override
    public DiagramCoordinate getLinkAnchorage(DiagramCoordinate indication) {
        return this.getCurrentBoundsCenter();
    }

    @Override
    public void requestFocus() {
        this.getVisualShape().requestFocus();
    }
}

