/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic;

import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IAngleLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.ContentVisualBase;

public abstract class CircularContentVisualBase
extends ContentVisualBase {
    public CircularContentVisualBase(IContentMVCBundle mvcb) {
        super(mvcb, (Shape)new Circle(), (Shape)new Circle());
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        Rectangle2D bounds = this.getCurrentBounds();
        double leftX = bounds.getMinX();
        double upperY = bounds.getMinY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double w2 = width / 2.0;
        double cx = leftX + w2;
        double h2 = height / 2.0;
        double cy = upperY + h2;
        double radius = Math.max(w2, h2);
        if (this.enableVisual()) {
            Circle circle = this.getVisualCircleShape();
            circle.setCenterX(cx);
            circle.setCenterY(cy);
            circle.setRadius(radius);
            circle.setOpacity(this.getOpacity());
            circle.setStroke(this.getBorderColor());
            circle.setStrokeWidth(this.getBorderWidth());
            circle.setStrokeType(this.getBorderType());
            circle.setFill(this.getFillColor());
        }
        if (this.enableInteraction()) {
            Circle ha = this.getHitAreaCircleShape();
            double lnk = this.getHitAreaStartLinkSize();
            double resize = this.getHitAreaResizeSize();
            radius = lnk + resize + radius;
            ha.setCenterX(cx);
            ha.setCenterY(cy);
            ha.setRadius(radius);
            Color interactionColor = this.getInteractionColor();
            ha.setStroke((Paint)interactionColor);
            ha.setFill((Paint)interactionColor);
        }
    }

    @Override
    public DiagramCoordinate getAnchorageLocation(IContentAnchorageVisual visual) {
        Rectangle2D pb = this.getCurrentBounds();
        double w2 = pb.getWidth() / 2.0;
        double h2 = pb.getHeight() / 2.0;
        double radius = Math.max(w2, h2);
        double angleDeg = visual.getLayout(IAngleLayout.class).getAngleInDegree();
        double angleRad = Math.toRadians(angleDeg);
        double nx = Math.cos(angleRad);
        double ny = Math.sin(angleRad);
        double x = w2 + radius * nx;
        double y = h2 + radius * ny;
        return new DiagramCoordinate(x, y);
    }

    @Override
    public DiagramCoordinate getLinkAnchorage(DiagramCoordinate indication) {
        return this.getLocationOnCircle(indication);
    }

    private DiagramCoordinate getLocationOnCircle(DiagramCoordinate indication) {
        Circle circ = this.getVisualCircleShape();
        double radius = this.getRadius(circ);
        double cx = circ.getCenterX();
        double dx = indication.getX() - cx;
        double cy = circ.getCenterY();
        double dy = indication.getY() - cy;
        double len = Math.hypot(dx, dy);
        double nx = radius * dx / len;
        double ny = radius * dy / len;
        return new DiagramCoordinate(cx + nx, cy + ny);
    }

    protected Dimension2D getCornerArcDimensions() {
        return new Dimension2D(15.0, 15.0);
    }

    @Override
    protected EDragGesture dragGestureHitTest(Node node, DiagramCoordinate diagramLocation) {
        Circle circ = this.getHitAreaCircleShape();
        if (node == circ) {
            double dx = diagramLocation.getX() - circ.getCenterX();
            double dy = diagramLocation.getY() - circ.getCenterY();
            double radius = this.getRadius(circ);
            double hypot = Math.hypot(dx, dy);
            if (hypot < radius - this.getHitAreaResizeSize() - this.getHitAreaStartLinkSize()) {
                return EDragGesture.MOVE;
            }
            if (hypot < radius - this.getHitAreaStartLinkSize()) {
                return EDragGesture.RESIZE_VH;
            }
            if (hypot < radius) {
                return EDragGesture.NEW_LINK;
            }
        }
        if (node == this.getVisualShape() || node == this.text) {
            return EDragGesture.MOVE;
        }
        return EDragGesture.NONE;
    }

    private double getRadius(Circle circ) {
        Bounds bounds = circ.getBoundsInLocal();
        double w2 = bounds.getWidth() / 2.0;
        double h2 = bounds.getHeight() / 2.0;
        double radius = Math.max(w2, h2);
        return radius;
    }

    protected final Circle getVisualCircleShape() {
        return (Circle)this.getVisualShape();
    }

    protected final Circle getHitAreaCircleShape() {
        return (Circle)this.getHitAreaShape();
    }

    protected double getHitAreaStartLinkSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }

    protected double getHitAreaResizeSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }
}

