/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic;

import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.DiagramAnchorageVisualBase;

public abstract class CircularDiagramAnchorageVisualBase
extends DiagramAnchorageVisualBase {
    public CircularDiagramAnchorageVisualBase(IDiagramAnchorageMVCBundle mvcb) {
        super(mvcb, (Shape)new Circle(), (Shape)new Circle());
    }

    protected final Circle getVisualCircle() {
        return (Circle)this.getVisualShape();
    }

    protected final Circle getHitAreaCircle() {
        return (Circle)this.getHitAreaShape();
    }

    private void updateCircleProperties() {
        Rectangle2D b = this.getCurrentBounds();
        double cx = b.getMinX() + b.getWidth() / 2.0;
        double cy = b.getMinY() + b.getHeight() / 2.0;
        if (this.enableVisual()) {
            Circle circle = this.getVisualCircle();
            circle.setCenterX(cx);
            circle.setCenterY(cy);
            circle.setRadius(this.getInnerRadius(b));
            circle.setOpacity(this.getOpacity());
            circle.setStrokeWidth(this.getBorderWidth());
            circle.setStrokeType(this.getBorderType());
            if (this.getMVCBundle().hasTag(DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG)) {
                circle.setFill(this.getHighlightIncomingLinkColor());
                circle.setStroke(this.getHighlightIncomingLinkBorderColor());
            } else if (this.getMVCBundle().hasTag(DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG)) {
                circle.setFill(this.getHighlightOutgoingLinkColor());
                circle.setStroke(this.getHighlightOutgoingLinkBorderColor());
            } else {
                circle.setFill(this.getFillColor());
                circle.setStroke(this.getBorderColor());
            }
        }
        if (this.enableInteraction()) {
            Circle ha = this.getHitAreaCircle();
            ha.setCenterX(cx);
            ha.setCenterY(cy);
            ha.setRadius(this.getOuterRadius(b));
            Color interactionColor = this.getInteractionColor();
            ha.setStroke((Paint)interactionColor);
            ha.setFill((Paint)interactionColor);
        }
    }

    private double getOuterRadius(Rectangle2D b) {
        return this.getInnerRadius(b) + this.getHitAreaOutset();
    }

    private double getInnerRadius(Rectangle2D b) {
        return b.getWidth() / 2.0 - this.getInset();
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        this.updateCircleProperties();
    }

    protected double getInset() {
        return 2.0;
    }

    @Override
    protected EDragGesture dragGestureHitTest(Node n, DiagramCoordinate diagramLocation) {
        if (n == this.getHitAreaCircle()) {
            Circle ha = this.getHitAreaCircle();
            double dx = Math.abs(diagramLocation.getX() - ha.getCenterX());
            double dy = Math.abs(diagramLocation.getY() - ha.getCenterY());
            Rectangle2D bounds = this.getCurrentBounds();
            double innerRadius = this.getInnerRadius(bounds);
            double outerRadius = this.getOuterRadius(bounds);
            double squaredLocation = dx * dx + dy * dy;
            if (squaredLocation > innerRadius * innerRadius && squaredLocation <= outerRadius * outerRadius) {
                return EDragGesture.NEW_LINK;
            }
            return EDragGesture.MOVE;
        }
        if (n == this.getVisualCircle()) {
            return EDragGesture.MOVE;
        }
        return EDragGesture.NONE;
    }
}

