/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic;

import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.LinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.LinkVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic.CurveSegment;

public abstract class CurveLinkVisualBase
extends LinkVisualBase {
    private final List<CurveSegment> segments = new LinkedList<CurveSegment>();
    private boolean curvesAddedToSceneGraph = false;

    public CurveLinkVisualBase(ILinkMVCBundle mvcb) {
        super(mvcb);
    }

    private void addCurveSegments(DiagramLayers layers) {
        LinkMVCBundle linkBundle = this.getLinkBundle();
        double markerSize = this.getFeedbackMarkerSize();
        double ms2 = markerSize / 2.0;
        Point2D sp = this.getFeedbackChangeForBendPoint(Integer.MIN_VALUE).applyToPoint(this.getStartAnchorPoint());
        DiagramCoordinate cp1 = this.getBendPointLocation(0);
        DiagramCoordinate cp2 = this.getBendPointLocation(1);
        this.startFeedbackHandle.setX(sp.getX() - ms2);
        this.startFeedbackHandle.setY(sp.getY() - ms2);
        this.startFeedbackHandle.setWidth(markerSize);
        this.startFeedbackHandle.setHeight(markerSize);
        int pts = this.getNumberOfBendPoints();
        int i = 2;
        while (i < pts) {
            DiagramCoordinate ep = this.getBendPointLocation(i);
            this.makeCurve(sp, cp1, cp2, ep, this.getInvisibleSelectionLineWidth(), markerSize, markerSize, false, true, 0.0, this.getLabelText(i, pts + 1));
            sp = ep;
            cp1 = this.getBendPointLocation(i + 1);
            cp2 = this.getBendPointLocation(i + 2);
            i += 3;
        }
        Point2D ep = this.getFeedbackChangeForBendPoint(-2147483647).applyToPoint(this.getEndAnchorPoint());
        this.makeCurve(sp, cp1, cp2, ep, this.getInvisibleSelectionLineWidth(), 0.0, markerSize, this.showArrowOnLastSegment(), this.useLineArrow(), this.getArrowLength(), this.getLabelText(pts, pts + 1));
        this.endFeedbackHandle.setX(ep.getX() - ms2);
        this.endFeedbackHandle.setY(ep.getY() - ms2);
        this.endFeedbackHandle.setWidth(markerSize);
        this.endFeedbackHandle.setHeight(markerSize);
        for (CurveSegment cs : this.segments) {
            cs.addLinkNodes(layers, linkBundle, this.getLabelText(this.segments.indexOf(cs), this.segments.size()));
        }
        this.curvesAddedToSceneGraph = true;
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        if (!this.enableVisual()) {
            if (this.curvesAddedToSceneGraph) {
                this.removeCurveSegments(layers);
            }
            return;
        }
        int pts = this.getNumberOfBendPoints();
        int expectedSegments = 1 + (pts - 2) / 3;
        if (!this.curvesAddedToSceneGraph) {
            this.addCurveSegments(layers);
        }
        if (this.segments.size() != expectedSegments) {
            this.removeCurveSegments(layers);
            this.addCurveSegments(layers);
            if (this.getViewer().getSelection().getPrimarySelection() == this.getLinkBundle()) {
                if (this.getViewer().hasFocus()) {
                    this.applySelectedFocusedEffect(layers);
                } else {
                    this.applySelectedNotFocusedEffect(layers);
                }
            }
            return;
        }
        int segIndex = 0;
        double markerSize = this.getFeedbackMarkerSize();
        double ms2 = markerSize / 2.0;
        Point2D sp = this.getFeedbackChangeForBendPoint(Integer.MIN_VALUE).applyToPoint(this.getStartAnchorPoint());
        this.startFeedbackHandle.setX(sp.getX() - ms2);
        this.startFeedbackHandle.setY(sp.getY() - ms2);
        this.startFeedbackHandle.setWidth(markerSize);
        this.startFeedbackHandle.setHeight(markerSize);
        Point2D cp1 = this.getFeedbackChangeForBendPoint(0).applyToPoint(this.getBendPointLocation(0));
        Point2D cp2 = this.getFeedbackChangeForBendPoint(1).applyToPoint(this.getBendPointLocation(1));
        int i = 2;
        while (i < pts) {
            Point2D ep = this.getFeedbackChangeForBendPoint(i).applyToPoint(this.getBendPointLocation(i));
            this.segments.get(segIndex).update(sp, cp1, cp2, ep, markerSize, markerSize, 0.0, this.getLabelText(i, pts));
            sp = ep;
            cp1 = this.getFeedbackChangeForBendPoint(i + 1).applyToPoint(this.getBendPointLocation(i + 1));
            cp2 = this.getFeedbackChangeForBendPoint(i + 2).applyToPoint(this.getBendPointLocation(i + 2));
            ++segIndex;
            i += 3;
        }
        Point2D ep = this.getFeedbackChangeForBendPoint(-2147483647).applyToPoint(this.getEndAnchorPoint());
        this.segments.get(segIndex).update(sp, cp1, cp2, ep, 0.0, markerSize, this.getArrowLength(), this.getLabelText(pts, pts));
        this.endFeedbackHandle.setX(ep.getX() - ms2);
        this.endFeedbackHandle.setY(ep.getY() - ms2);
        this.endFeedbackHandle.setWidth(markerSize);
        this.endFeedbackHandle.setHeight(markerSize);
        Paint color = this.getLineColor();
        IMVCBundle mvcBundle = this.getMVCBundle();
        if (mvcBundle.hasTag(DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG)) {
            color = this.getHighlightIncomingLinkColor();
        } else if (mvcBundle.hasTag(DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG)) {
            color = this.getHighlightOutgoingLinkColor();
        } else if (mvcBundle.hasTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG)) {
            color = mvcBundle.hasTag(DiagramViewerDefaultTags.FOCUS_TAG) ? this.getSelectionFocusedColor() : this.getSelectionNotFocusedColor();
        }
        for (CurveSegment seg : this.segments) {
            seg.setStrokeColor(color);
        }
    }

    @Override
    public void removeAllVisuals(DiagramLayers layers) {
        super.removeAllVisuals(layers);
        this.removeCurveSegments(layers);
    }

    private void removeCurveSegments(DiagramLayers layers) {
        for (CurveSegment cs : this.segments) {
            cs.removeLinkNodes(layers);
            cs.removeFeedbackNodes(layers);
        }
        DiagramLayers.ILayer l = layers.getLinkInteractionLayer();
        l.remove((Node)this.startFeedbackHandle);
        l.remove((Node)this.endFeedbackHandle);
        this.segments.clear();
        this.curvesAddedToSceneGraph = false;
    }

    @Override
    public boolean enableVisual() {
        return true;
    }

    @Override
    public boolean enableInteraction() {
        return true;
    }

    @Override
    public DiagramCoordinate getStartAnchorPoint() {
        Point2D target;
        IAnchorageMVCBundle start = this.getLinkBundle().getStartAnchorage();
        Rectangle2D sb = start.getVisual().getCurrentBounds();
        int pts = this.getNumberOfBendPoints();
        if (pts == 0) {
            IAnchorageMVCBundle end = this.getLinkBundle().getEndAnchorage();
            Rectangle2D eb = end.getVisual().getCurrentBounds();
            target = new Point2D(eb.getMinX() + eb.getWidth() / 2.0, eb.getMinY() + eb.getHeight() / 2.0);
        } else {
            target = this.getCurrentBendPointLocation(0);
        }
        return this.getStartAnchorLocation(sb, target);
    }

    @Override
    public DiagramCoordinate getEndAnchorPoint() {
        Point2D target;
        IAnchorageMVCBundle end = this.getLinkBundle().getEndAnchorage();
        Rectangle2D eb = end.getVisual().getCurrentBounds();
        int pts = this.getNumberOfBendPoints();
        if (pts == 0) {
            IAnchorageMVCBundle start = this.getLinkBundle().getStartAnchorage();
            Rectangle2D sb = start.getVisual().getCurrentBounds();
            target = new Point2D(sb.getMinX() + sb.getWidth() / 2.0, sb.getMinY() + sb.getHeight() / 2.0);
        } else {
            target = this.getCurrentBendPointLocation(pts - 1);
        }
        return this.getEndAnchorLocation(eb, target);
    }

    @Override
    public void applySelectedFocusedEffect(DiagramLayers layers) {
        LinkMVCBundle bundle = this.getLinkBundle();
        Paint selectionFocusedColor = this.getSelectionFocusedColor();
        Paint interactionColor = this.getInteractionColor();
        for (CurveSegment seg : this.segments) {
            seg.setStrokeColor(selectionFocusedColor);
            seg.setClickableLinesColor(interactionColor);
            seg.addFeedbackNodes(layers, bundle);
        }
        DiagramLayers.ILayer linkInteractionLayer = layers.getLinkInteractionLayer();
        linkInteractionLayer.add((Node)this.startFeedbackHandle, bundle);
        linkInteractionLayer.add((Node)this.endFeedbackHandle, bundle);
    }

    @Override
    public void applySelectedNotFocusedEffect(DiagramLayers layers) {
        this.removeFeedback(layers, this.getSelectionNotFocusedColor());
    }

    @Override
    protected void applyNotSelectedEffect(DiagramLayers layers) {
        this.removeFeedback(layers, this.getInteractionColor());
    }

    private void removeFeedback(DiagramLayers layers, Paint lineColor) {
        Paint selectionNotFocusedColor = lineColor;
        Paint interactionColor = this.getInteractionColor();
        for (CurveSegment seg : this.segments) {
            seg.setStrokeColor(selectionNotFocusedColor);
            seg.setClickableLinesColor(interactionColor);
            seg.removeFeedbackNodes(layers);
        }
        DiagramLayers.ILayer linkInteractionLayer = layers.getLinkInteractionLayer();
        linkInteractionLayer.remove((Node)this.startFeedbackHandle);
        linkInteractionLayer.remove((Node)this.endFeedbackHandle);
    }

    protected abstract DiagramCoordinate getStartAnchorLocation(Rectangle2D var1, Point2D var2);

    protected abstract DiagramCoordinate getEndAnchorLocation(Rectangle2D var1, Point2D var2);

    protected Paint getSelectionFocusedColor() {
        return Color.RED;
    }

    protected Paint getSelectionNotFocusedColor() {
        return Color.ORANGE;
    }

    protected Paint getLineColor() {
        return Color.BLACK;
    }

    private Point2D getCurrentBendPointLocation(int bendPointIndex) {
        if (bendPointIndex >= 0 && bendPointIndex < this.getNumberOfBendPoints()) {
            DiagramCoordinate bendPoint = this.getBendPointLocation(bendPointIndex);
            FeedbackChange chg = this.getFeedbackChangeForBendPoint(bendPointIndex);
            double x = bendPoint.getX() + chg.getDeltaX();
            double y = bendPoint.getY() + chg.getDeltaY();
            return new Point2D(x, y);
        }
        throw new IndexOutOfBoundsException("No bend-point exists at index " + bendPointIndex);
    }

    protected abstract Object getBendPointModel(int var1);

    protected abstract int getNumberOfBendPoints();

    protected abstract double getInvisibleSelectionLineWidth();

    private void makeCurve(Point2D sp, Point2D cp1, Point2D cp2, Point2D ep, double selWidth, double bpMarkerSize, double cpMarkerSize, boolean showArrow, boolean useLineArrow, double arrowLength, String labelText) {
        CurveSegment segVis = new CurveSegment(sp.getX(), sp.getY(), cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), ep.getX(), ep.getY(), selWidth, bpMarkerSize, cpMarkerSize, showArrow, useLineArrow, arrowLength, labelText);
        this.segments.add(segVis);
    }

    private LinkMVCBundle getLinkBundle() {
        return (LinkMVCBundle)this.getMVCBundle();
    }

    @Override
    public Rectangle2D getCurrentBounds() {
        return Rectangle2D.EMPTY;
    }

    @Override
    public int getBendPointIndex(Node node) {
        int superResult = super.getBendPointIndex(node);
        if (superResult != -2147483646) {
            return superResult;
        }
        int i = 0;
        while (i < this.segments.size()) {
            CurveSegment cs = this.segments.get(i);
            if (node == cs.getFirstControlPointHandle()) {
                return i * 3;
            }
            if (node == cs.getSecondControlPointHandle()) {
                return 1 + i * 3;
            }
            if (node == cs.getBendPointHandle()) {
                return 2 + i * 3;
            }
            if (node == cs.getVisibleCurve() || node == cs.getClickableCurve()) {
                return 2 + i * 3;
            }
            ++i;
        }
        return -2147483646;
    }

    @Override
    public boolean isBendPointHandle(Node node) {
        for (CurveSegment cs : this.segments) {
            if (node != cs.getBendPointHandle() && node != cs.getFirstControlPointHandle() && node != cs.getSecondControlPointHandle()) continue;
            return true;
        }
        return super.isBendPointHandle(node);
    }

    @Override
    public void requestFocus() {
        if (!this.segments.isEmpty()) {
            this.segments.get(0).getVisibleCurve().requestFocus();
        }
    }

    protected abstract boolean showArrowOnLastSegment();

    protected boolean useLineArrow() {
        return false;
    }

    protected double getArrowLength() {
        return 10.0;
    }

    @Override
    public EDragGesture getDragGesture(Node node, DiagramCoordinate diagramLocation) {
        if (node == this.startFeedbackHandle || node == this.endFeedbackHandle) {
            return EDragGesture.RECONNECT_LINK;
        }
        for (CurveSegment cs : this.segments) {
            if (node == cs.getBendPointHandle() || node == cs.getFirstControlPointHandle() || node == cs.getSecondControlPointHandle()) {
                return EDragGesture.MOVE_BENDPOINT;
            }
            if (node != cs.getClickableCurve()) continue;
            return EDragGesture.NEW_BENDPOINT;
        }
        return EDragGesture.NONE;
    }

    @Override
    public void enableFeedback() {
        super.enableFeedback();
        for (CurveSegment cs : this.segments) {
            cs.setMouseTransparent(false);
        }
    }

    @Override
    public void disableFeedback() {
        super.disableFeedback();
        for (CurveSegment cs : this.segments) {
            cs.setMouseTransparent(true);
        }
    }

    protected String getLabelText(int currentSegment, int lastSegment) {
        return null;
    }
}

