/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic;

import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.TextAlignment;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.widgets.LinkArrowWidget;

final class CurveSegment {
    private final CubicCurve visibleCurve;
    private final CubicCurve clickableCurve;
    private final Rectangle firstControlPointHandle;
    private final Rectangle secondControlPointHandle;
    private final Rectangle bendPointHandle;
    private final Line helperStart;
    private final Line helperEnd;
    private final LinkArrowWidget arrowWidget;
    private Label label;

    public CurveSegment(double sx, double sy, double c1x, double c1y, double c2x, double c2y, double ex, double ey, double selectionStrokeWidth, double bendPointFeedbackSize, double controlPointFeedbackSize, boolean showArrow, boolean useLineArrow, double arrowLength, String labelText) {
        this.visibleCurve = new CubicCurve(sx, sy, c1x, c1y, c2x, c2y, ex, ey);
        this.visibleCurve.setStroke((Paint)Color.BLACK);
        this.visibleCurve.setFill(null);
        this.clickableCurve = new CubicCurve(sx, sy, c1x, c1y, c2x, c2y, ex, ey);
        this.clickableCurve.setStrokeWidth(selectionStrokeWidth);
        this.clickableCurve.setFill(null);
        this.clickableCurve.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.clickableCurve.setStrokeLineCap(StrokeLineCap.BUTT);
        this.clickableCurve.setStroke((Paint)Color.TRANSPARENT);
        double fs2 = bendPointFeedbackSize / 2.0;
        this.bendPointHandle = new Rectangle(ex - fs2, ey - fs2, bendPointFeedbackSize, bendPointFeedbackSize);
        this.bendPointHandle.setFill((Paint)Color.TRANSPARENT);
        this.bendPointHandle.setStroke((Paint)Color.RED);
        double cps2 = controlPointFeedbackSize / 2.0;
        this.firstControlPointHandle = new Rectangle(c1x - cps2, c1y - cps2, controlPointFeedbackSize, controlPointFeedbackSize);
        this.firstControlPointHandle.setFill((Paint)Color.TRANSPARENT);
        this.firstControlPointHandle.setStroke((Paint)Color.GRAY);
        this.secondControlPointHandle = new Rectangle(c2x - cps2, c2y - cps2, controlPointFeedbackSize, controlPointFeedbackSize);
        this.secondControlPointHandle.setFill((Paint)Color.TRANSPARENT);
        this.secondControlPointHandle.setStroke((Paint)Color.GRAY);
        this.helperStart = new Line(sx, sy, c1x, c1y);
        this.helperStart.setStroke((Paint)Color.GRAY);
        this.helperEnd = new Line(c2x, c2y, ex, ey);
        this.helperEnd.setStroke((Paint)Color.GRAY);
        this.arrowWidget = showArrow ? new LinkArrowWidget(useLineArrow, ex, ey, c2x, c2y, arrowLength) : null;
        if (labelText != null) {
            this.label = new Label(labelText);
            this.label.setTextAlignment(TextAlignment.CENTER);
        } else {
            this.label = null;
        }
    }

    public CubicCurve getVisibleCurve() {
        return this.visibleCurve;
    }

    public CubicCurve getClickableCurve() {
        return this.clickableCurve;
    }

    public Rectangle getFirstControlPointHandle() {
        return this.firstControlPointHandle;
    }

    public Rectangle getSecondControlPointHandle() {
        return this.secondControlPointHandle;
    }

    public Rectangle getBendPointHandle() {
        return this.bendPointHandle;
    }

    public Line getHelperStart() {
        return this.helperStart;
    }

    public Line getHelperEnd() {
        return this.helperEnd;
    }

    public void setStrokeColor(Paint color) {
        this.visibleCurve.setStroke(color);
        if (this.arrowWidget != null) {
            this.arrowWidget.setColor(color);
        }
    }

    public void setClickableLinesColor(Paint color) {
        this.clickableCurve.setStroke(color);
    }

    public void update(Point2D sp, Point2D cp1, Point2D cp2, Point2D ep, double bendPointFeedbackSize, double controlPointFeedbackSize, double arrowLength, String labelText) {
        double sx = sp.getX();
        double sy = sp.getY();
        this.visibleCurve.setStartX(sx);
        this.visibleCurve.setStartY(sy);
        double c1x = cp1.getX();
        double c1y = cp1.getY();
        this.visibleCurve.setControlX1(c1x);
        this.visibleCurve.setControlY1(c1y);
        double c2x = cp2.getX();
        double c2y = cp2.getY();
        this.visibleCurve.setControlX2(c2x);
        this.visibleCurve.setControlY2(c2y);
        double ex = ep.getX();
        double ey = ep.getY();
        this.visibleCurve.setEndX(ex);
        this.visibleCurve.setEndY(ey);
        this.clickableCurve.setStartX(sx);
        this.clickableCurve.setStartY(sy);
        this.clickableCurve.setControlX1(c1x);
        this.clickableCurve.setControlY1(c1y);
        this.clickableCurve.setControlX2(c2x);
        this.clickableCurve.setControlY2(c2y);
        this.clickableCurve.setEndX(ex);
        this.clickableCurve.setEndY(ey);
        double cps2 = controlPointFeedbackSize / 2.0;
        this.firstControlPointHandle.setX(c1x - cps2);
        this.firstControlPointHandle.setY(c1y - cps2);
        this.secondControlPointHandle.setX(c2x - cps2);
        this.secondControlPointHandle.setY(c2y - cps2);
        double bps2 = bendPointFeedbackSize / 2.0;
        this.bendPointHandle.setX(ex - bps2);
        this.bendPointHandle.setY(ey - bps2);
        this.helperStart.setStartX(sx);
        this.helperStart.setStartY(sy);
        this.helperStart.setEndX(c1x);
        this.helperStart.setEndY(c1y);
        this.helperEnd.setStartX(c2x);
        this.helperEnd.setStartY(c2y);
        this.helperEnd.setEndX(ex);
        this.helperEnd.setEndY(ey);
        if (this.arrowWidget != null) {
            this.arrowWidget.update(ex, ey, c2x, c2y, arrowLength);
        }
        if (this.label != null) {
            this.label.setText(labelText);
            double lx = (sx + ex - this.label.getBoundsInLocal().getWidth()) / 2.0;
            double ly = (sy + ey) / 2.0;
            this.label.setLayoutX(lx);
            this.label.setLayoutY(ly);
        }
    }

    public void addLinkNodes(DiagramLayers layers, ILinkMVCBundle bundle, String labelText) {
        DiagramLayers.ILayer linkLayer = layers.getLinkLayer();
        linkLayer.add((Node)this.visibleCurve, bundle);
        linkLayer.add((Node)this.clickableCurve, bundle);
        if (this.arrowWidget != null) {
            linkLayer.add((Node)this.arrowWidget, bundle);
        }
        if (this.label != null) {
            this.label.setText(labelText);
            this.label.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(0.0), new Insets(0.0))}));
            layers.getTextLayer().add((Node)this.label, bundle);
        }
    }

    public void removeLinkNodes(DiagramLayers layers) {
        DiagramLayers.ILayer linkLayer = layers.getLinkLayer();
        linkLayer.remove((Node)this.visibleCurve);
        linkLayer.remove((Node)this.clickableCurve);
        if (this.arrowWidget != null) {
            linkLayer.remove((Node)this.arrowWidget);
        }
        if (this.label != null) {
            layers.getTextLayer().remove((Node)this.label);
        }
    }

    public void addFeedbackNodes(DiagramLayers layers, ILinkMVCBundle bundle) {
        layers.getVisualFeedbackLayer().add((Node)this.helperStart, bundle);
        layers.getVisualFeedbackLayer().add((Node)this.helperEnd, bundle);
        layers.getLinkInteractionLayer().add((Node)this.firstControlPointHandle, bundle);
        layers.getLinkInteractionLayer().add((Node)this.bendPointHandle, bundle);
        layers.getLinkInteractionLayer().add((Node)this.secondControlPointHandle, bundle);
    }

    public void removeFeedbackNodes(DiagramLayers layers) {
        layers.getVisualFeedbackLayer().remove((Node)this.helperStart);
        layers.getVisualFeedbackLayer().remove((Node)this.helperEnd);
        layers.getLinkInteractionLayer().remove((Node)this.firstControlPointHandle);
        layers.getLinkInteractionLayer().remove((Node)this.bendPointHandle);
        layers.getLinkInteractionLayer().remove((Node)this.secondControlPointHandle);
    }

    public void setMouseTransparent(boolean transparent) {
        this.visibleCurve.setMouseTransparent(transparent);
        this.clickableCurve.setMouseTransparent(transparent);
        this.bendPointHandle.setMouseTransparent(transparent);
        this.firstControlPointHandle.setMouseTransparent(transparent);
        this.secondControlPointHandle.setMouseTransparent(transparent);
        if (this.arrowWidget != null) {
            this.arrowWidget.setMouseTransparent(transparent);
        }
        if (this.label != null) {
            this.label.setMouseTransparent(transparent);
        }
    }
}

