/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic;

import java.util.Objects;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;

public final class EllipticBorderLocation {
    private final double angleInDegree;
    private final Dimension2D radiuses;
    private final Dimension2D correction;

    public EllipticBorderLocation(double angleInDegree, Dimension2D radiuses, Dimension2D correction) {
        this.angleInDegree = angleInDegree;
        this.radiuses = Objects.requireNonNull(radiuses);
        this.correction = Objects.requireNonNull(correction);
    }

    public double getAngleInDegree() {
        return this.angleInDegree;
    }

    public Dimension2D getRadiuses() {
        return this.radiuses;
    }

    public DiagramCoordinate getLocation() {
        double angle = Math.PI * this.angleInDegree / 180.0;
        double rh = this.radiuses.getWidth();
        double rv = this.radiuses.getHeight();
        DiagramCoordinate middle = new DiagramCoordinate(rh, rv);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double tan = sin / cos;
        double x = rh * rv / Math.sqrt(rv * rv + rh * rh * tan * tan);
        double y = rh * rv * Math.signum(tan) / Math.sqrt(rv * rv / (tan * tan) + rh * rh);
        return middle.add(x * Math.signum(cos), -y * Math.signum(cos)).subtract(this.correction.getWidth() / 2.0, this.correction.getHeight() / 2.0);
    }

    public static final EllipticBorderLocation getClosestLocationOnBounds(Point2D point, Rectangle2D ellipse, Dimension2D size) {
        double w2 = ellipse.getWidth() / 2.0;
        double h2 = ellipse.getHeight() / 2.0;
        double dx = point.getX() - w2;
        double dy = h2 - point.getY();
        double angle = Math.atan2(dy, dx) * 180.0 / Math.PI;
        Dimension2D radiuses = new Dimension2D(w2, h2);
        return new EllipticBorderLocation(angle, radiuses, size);
    }
}

