/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic;

import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Shape;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IAngleLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.ContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic.EllipticBorderLocation;

public abstract class EllipticContentVisualBase
extends ContentVisualBase {
    public EllipticContentVisualBase(IContentMVCBundle mvcb) {
        super(mvcb, (Shape)new Ellipse(), (Shape)new Ellipse());
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        this.updateNodeProperties();
    }

    @Override
    public DiagramCoordinate getAnchorageLocation(IContentAnchorageVisual visual) {
        Rectangle2D pb = this.getCurrentBounds();
        Dimension2D ell = new Dimension2D(pb.getWidth() / 2.0, pb.getHeight() / 2.0);
        Dimension2D dim = visual.getDimensions();
        double angleDeg = visual.getLayout(IAngleLayout.class).getAngleInDegree();
        EllipticBorderLocation ebl = new EllipticBorderLocation(angleDeg, ell, dim);
        return ebl.getLocation();
    }

    @Override
    public DiagramCoordinate getLinkAnchorage(DiagramCoordinate indication) {
        Rectangle2D pb = this.getCurrentBounds();
        EllipticBorderLocation ebl = EllipticBorderLocation.getClosestLocationOnBounds(indication.add(-pb.getMinX(), -pb.getMinY()), pb, new Dimension2D(1.0, 1.0));
        return ebl.getLocation().add(pb.getMinX(), pb.getMinY());
    }

    @Override
    protected Paint getBorderColor() {
        return Color.DARKORANGE.darker();
    }

    @Override
    protected Paint getFillColor() {
        return Color.ORANGE.brighter();
    }

    private void updateNodeProperties() {
        Rectangle2D bounds = this.getCurrentBounds();
        double w2 = bounds.getWidth() / 2.0;
        double h2 = bounds.getHeight() / 2.0;
        Ellipse ellipse = this.getVisualEllipse();
        ellipse.setCenterX(bounds.getMinX() + w2);
        ellipse.setCenterY(bounds.getMinY() + h2);
        ellipse.setRadiusX(w2);
        ellipse.setRadiusY(h2);
        ellipse.setOpacity(this.getOpacity());
        ellipse.setStroke(this.getBorderColor());
        ellipse.setStrokeWidth(this.getBorderWidth());
        ellipse.setStrokeType(this.getBorderType());
        ellipse.setFill(this.getFillColor());
        double lnk = this.getHitAreaStartLinkSize();
        double res = this.getHitAreaResizeSize();
        Ellipse hitShape = this.getHitAreaEllipse();
        hitShape.setCenterX(bounds.getMinX() + w2);
        hitShape.setCenterY(bounds.getMinY() + h2);
        hitShape.setRadiusX(w2 + lnk + res / 2.0);
        hitShape.setRadiusY(h2 + lnk + res / 2.0);
        Color interactionColor = this.getInteractionColor();
        hitShape.setStroke((Paint)interactionColor);
        hitShape.setFill((Paint)interactionColor);
    }

    @Override
    protected EDragGesture dragGestureHitTest(Node node, DiagramCoordinate diagramLocation) {
        if (node == this.getHitAreaShape()) {
            double b;
            double lnk;
            Bounds bounds = node.getBoundsInLocal();
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            double x = diagramLocation.getLocalX(node) - w / 2.0;
            double y = diagramLocation.getLocalY(node) - h / 2.0;
            double res = this.getHitAreaResizeSize();
            double a = w / 2.0 - res - (lnk = this.getHitAreaStartLinkSize());
            double hitMoveArea = x * x / (a * a) + y * y / ((b = h / 2.0 - res - lnk) * b);
            if (hitMoveArea <= 1.0) {
                return EDragGesture.MOVE;
            }
            a = w / 2.0 - lnk;
            b = h / 2.0 - lnk;
            double hitResizeArea = x * x / (a * a) + y * y / (b * b);
            if (hitResizeArea <= 1.0) {
                double angle = (360.0 + Math.toDegrees(Math.atan2(-y, x))) % 360.0;
                if (angle <= 45.0 || angle >= 345.0) {
                    return EDragGesture.RESIZE_H;
                }
                if (angle >= 300.0) {
                    return EDragGesture.RESIZE_VH;
                }
                if (angle >= 225.0) {
                    return EDragGesture.RESIZE_V;
                }
                return EDragGesture.NONE;
            }
            return EDragGesture.NEW_LINK;
        }
        if (node == this.getVisualEllipse() || node == this.text) {
            return EDragGesture.MOVE;
        }
        return EDragGesture.NONE;
    }

    protected double getHitAreaStartLinkSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }

    protected double getHitAreaResizeSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }

    protected final Ellipse getVisualEllipse() {
        return (Ellipse)this.getVisualShape();
    }

    protected final Ellipse getHitAreaEllipse() {
        return (Ellipse)this.getHitAreaShape();
    }
}

