/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.ISideLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.ContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularBorderLocation;

public abstract class DiamondContentVisualBase
extends ContentVisualBase {
    private static final double DEFAULT_TEXTANCHOR_DIVIDER = 5.0;

    public DiamondContentVisualBase(IContentMVCBundle mvcb) {
        super(mvcb, (Shape)new Path(), (Shape)new Path());
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        Rectangle2D bounds = this.getCurrentBounds();
        double leftX = bounds.getMinX();
        double upperY = bounds.getMinY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (this.enableVisual()) {
            Path path = this.getVisualPathShape();
            path.setOpacity(this.getOpacity());
            path.setStroke(this.getBorderColor());
            path.setStrokeWidth(this.getBorderWidth());
            path.setStrokeType(this.getBorderType());
            path.setFill(this.getFillColor());
            this.makePath(leftX, upperY, width, height, path);
        }
        if (this.enableInteraction()) {
            Path ha = this.getHitAreaPathShape();
            double lnk = this.getHitAreaStartLinkSize();
            double resize = this.getHitAreaResizeSize();
            double lr = lnk + resize;
            this.makePath(leftX - lr, upperY - lr, width + 2.0 * lr, height + 2.0 * lr, ha);
            Color interactionColor = this.getInteractionColor();
            ha.setStroke((Paint)interactionColor);
            ha.setFill((Paint)interactionColor);
        }
    }

    private void makePath(double x, double y, double w, double h, Path p) {
        double w2 = w / 2.0;
        double h2 = h / 2.0;
        ObservableList pes = p.getElements();
        pes.clear();
        pes.add((Object)new MoveTo(x, y + h2));
        pes.add((Object)new LineTo(x + w2, y + h));
        pes.add((Object)new LineTo(x + w, y + h2));
        pes.add((Object)new LineTo(x + w2, y));
        pes.add((Object)new ClosePath());
    }

    @Override
    public DiagramCoordinate getAnchorageLocation(IContentAnchorageVisual visual) {
        Rectangle2D pb = this.getCurrentBounds();
        double pbw2 = pb.getWidth() / 2.0;
        double pbh2 = pb.getHeight() / 2.0;
        Dimension2D anchorageSize = visual.getDimensions();
        double aw2 = anchorageSize.getWidth() / 2.0;
        double ah2 = anchorageSize.getHeight() / 2.0;
        Side side = visual.getLayout(ISideLayout.class).getSide();
        double x = pbw2 - aw2;
        double y = -ah2;
        if (side == Side.BOTTOM) {
            y = pb.getHeight() - ah2;
        } else if (side == Side.LEFT) {
            x = -aw2;
            y = pbh2 - ah2;
        } else if (side == Side.RIGHT) {
            x = pb.getWidth() - aw2;
            y = pbh2 - ah2;
        }
        return new DiagramCoordinate(x, y);
    }

    @Override
    public DiagramCoordinate getLinkAnchorage(DiagramCoordinate indication) {
        Rectangle2D b = this.getCurrentBounds();
        Dimension2D dummy = new Dimension2D(1.0, 1.0);
        RectangularBorderLocation loc = RectangularBorderLocation.getClosestLocationOnBounds(indication.add(-b.getMinX(), -b.getMinY()), b, dummy, dummy);
        return loc.getLocation().add(b.getMinX(), b.getMinY());
    }

    protected Dimension2D getCornerArcDimensions() {
        return new Dimension2D(15.0, 15.0);
    }

    @Override
    protected EDragGesture dragGestureHitTest(Node node, DiagramCoordinate diagramLocation) {
        if (node == this.getHitAreaShape()) {
            Bounds bounds;
            double r;
            double x = diagramLocation.getLocalX(node);
            double y = diagramLocation.getLocalY(node);
            double l = this.getHitAreaStartLinkSize();
            double inset = l + (r = this.getHitAreaResizeSize());
            Rectangle2D moveArea = new Rectangle2D(inset, inset, (bounds = node.getBoundsInLocal()).getWidth() - 2.0 * inset, bounds.getHeight() - 2.0 * inset);
            if (moveArea.contains(x, y)) {
                return EDragGesture.MOVE;
            }
            if (x < l || y < l || x > bounds.getWidth() - l || y > bounds.getHeight() - l) {
                return EDragGesture.NEW_LINK;
            }
            if (x > bounds.getWidth() - inset && y >= l && y <= bounds.getHeight() - inset) {
                return EDragGesture.RESIZE_H;
            }
            if (y > bounds.getHeight() - inset && x >= l && x <= bounds.getWidth() - inset) {
                return EDragGesture.RESIZE_V;
            }
            if (x > bounds.getWidth() - inset && y > bounds.getHeight() - inset) {
                return EDragGesture.RESIZE_VH;
            }
            return EDragGesture.NONE;
        }
        if (node == this.getVisualShape() || node == this.text) {
            return EDragGesture.MOVE;
        }
        return EDragGesture.NONE;
    }

    protected final Path getVisualPathShape() {
        return (Path)this.getVisualShape();
    }

    protected final Path getHitAreaPathShape() {
        return (Path)this.getHitAreaShape();
    }

    protected double getHitAreaStartLinkSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }

    protected double getHitAreaResizeSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }

    @Override
    protected DiagramCoordinate getTextAnchorLocation() {
        DiagramCoordinate textAnchorLocation = super.getTextAnchorLocation();
        return textAnchorLocation.add(this.getCurrentBounds().getWidth() / 5.0, 0.0);
    }
}

