/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.shape.Line;
import javafx.util.Pair;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.LineSegment;

public class LineLinkGraph {
    private Map<LineSegment, List<Line>> segment2lines = new HashMap<LineSegment, List<Line>>();
    private Map<Line, LineSegment> line2segment = new HashMap<Line, LineSegment>();
    private Map<Line, Set<Pair<Line, Line>>> line2interruptedLine = new HashMap<Line, Set<Pair<Line, Line>>>();

    public void addSegment(LineSegment seg, List<Line> lines) {
        this.segment2lines.put(seg, lines);
        for (Line l : lines) {
            this.line2segment.put(l, seg);
        }
    }

    public void removeSegment(LineSegment seg, List<Line> lines) {
        this.segment2lines.remove(seg);
        for (Line l : lines) {
            this.line2segment.remove(l);
        }
    }

    public void addInterruptedLine(Line line, Line interruptedLine1, Line interruptedLine2) {
        Set<Pair<Line, Line>> set = this.line2interruptedLine.get(line);
        if (set == null) {
            set = new HashSet<Pair<Line, Line>>();
        }
        set.add((Pair<Line, Line>)new Pair((Object)interruptedLine1, (Object)interruptedLine2));
        this.line2interruptedLine.put(line, set);
    }

    public void addInterruptedLines(Map<Line, Pair<Line, Line>> lines) {
        for (Line line : lines.keySet()) {
            Pair<Line, Line> pair = lines.get(line);
            this.addInterruptedLine(line, (Line)pair.getKey(), (Line)pair.getValue());
        }
    }

    public Map<Line, LineSegment> getLine2segment() {
        return this.line2segment;
    }
}

