/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular;

import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.impl.LinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.LinkVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.LineSegment;

public abstract class LineLinkVisualBase
extends LinkVisualBase {
    private static final double DEFAULT_ARROW_LENGTH = 10.0;
    private final List<LineSegment> segments = new LinkedList<LineSegment>();
    private boolean linesAddedToSceneGraph = false;

    public LineLinkVisualBase(ILinkMVCBundle mvcb) {
        super(mvcb);
    }

    private void addLineSegments(DiagramLayers layers) {
        Object bpModel = null;
        double feedbackSize = this.getFeedbackMarkerSize();
        double fs2 = feedbackSize / 2.0;
        Point2D startAnchorPoint = this.getFeedbackChangeForBendPoint(Integer.MIN_VALUE).applyToPoint(this.getStartAnchorPoint());
        double sx = startAnchorPoint.getX();
        double sy = startAnchorPoint.getY();
        this.startFeedbackHandle.setX(sx - fs2);
        this.startFeedbackHandle.setY(sy - fs2);
        this.startFeedbackHandle.setWidth(feedbackSize);
        this.startFeedbackHandle.setHeight(feedbackSize);
        int pts = this.getNumberOfBendPoints();
        int i = 0;
        while (i < pts) {
            DiagramCoordinate bp = this.getBendPointLocation(i);
            FeedbackChange chg = this.getFeedbackChangeForBendPoint(i);
            double nx = bp.getX() + chg.getDeltaX();
            double ny = bp.getY() + chg.getDeltaY();
            this.segments.add(new LineSegment(bpModel, sx, sy, nx, ny, this.getInvisibleSelectionLineWidth(), feedbackSize, false, false, 0.0, this.getLabelText(i, pts + 1), this.getSimulationLabelText(i, pts + 1)));
            sx = nx;
            sy = ny;
            bpModel = this.getBendPointModel(i);
            ++i;
        }
        Point2D endPoint = this.getFeedbackChangeForBendPoint(-2147483647).applyToPoint(this.getEndAnchorPoint());
        this.segments.add(new LineSegment(bpModel, sx, sy, endPoint.getX(), endPoint.getY(), this.getInvisibleSelectionLineWidth(), 0.0, this.showArrowOnLastSegment(), this.useLineArrow(), this.getArrowLength(), this.getLabelText(pts, pts + 1), this.getSimulationLabelText(pts, pts + 1)));
        this.endFeedbackHandle.setX(endPoint.getX() - fs2);
        this.endFeedbackHandle.setY(endPoint.getY() - fs2);
        this.endFeedbackHandle.setWidth(feedbackSize);
        this.endFeedbackHandle.setHeight(feedbackSize);
        LinkMVCBundle bundle = this.getLinkBundle();
        int numberOfSegs = this.segments.size();
        int i2 = 0;
        while (i2 < numberOfSegs) {
            LineSegment ls = this.segments.get(i2);
            ls.addLinkNodes(layers, bundle, this.getLabelText(i2, numberOfSegs), this.getSimulationLabelText(i2, numberOfSegs));
            ++i2;
        }
        this.linesAddedToSceneGraph = true;
    }

    @Override
    public void removeAllVisuals(DiagramLayers layers) {
        super.removeAllVisuals(layers);
        this.removeLineSegments(layers);
    }

    private void removeLineSegments(DiagramLayers layers) {
        for (LineSegment ls : this.segments) {
            ls.removeLinkNodes(layers);
            ls.removeFeedbackNodes(layers);
        }
        DiagramLayers.ILayer linkInteractionLayer = layers.getLinkInteractionLayer();
        linkInteractionLayer.remove((Node)this.startFeedbackHandle);
        linkInteractionLayer.remove((Node)this.endFeedbackHandle);
        this.segments.clear();
        this.linesAddedToSceneGraph = false;
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        if (!this.enableVisual()) {
            if (this.linesAddedToSceneGraph) {
                this.removeLineSegments(layers);
            }
            return;
        }
        int pts = this.getNumberOfBendPoints();
        int expectedSegments = 1 + pts;
        if (!this.linesAddedToSceneGraph) {
            this.addLineSegments(layers);
        }
        if (this.segments.size() != expectedSegments) {
            this.removeLineSegments(layers);
            this.addLineSegments(layers);
            if (this.getViewer().getSelection().getPrimarySelection() == this.getLinkBundle()) {
                if (this.getViewer().hasFocus()) {
                    this.applySelectedFocusedEffect(layers);
                } else {
                    this.applySelectedNotFocusedEffect(layers);
                }
            }
            return;
        }
        int segIndex = 0;
        double feedbackSize = this.getFeedbackMarkerSize();
        double fs2 = feedbackSize / 2.0;
        Point2D sp = this.getFeedbackChangeForBendPoint(Integer.MIN_VALUE).applyToPoint(this.getStartAnchorPoint());
        this.startFeedbackHandle.setX(sp.getX() - fs2);
        this.startFeedbackHandle.setY(sp.getY() - fs2);
        this.startFeedbackHandle.setWidth(feedbackSize);
        this.startFeedbackHandle.setHeight(feedbackSize);
        int i = 0;
        while (i < pts) {
            Point2D ep = this.getFeedbackChangeForBendPoint(i).applyToPoint(this.getBendPointLocation(i));
            this.segments.get(segIndex).update(sp, ep, feedbackSize, 0.0, this.getLabelText(i, pts), this.getSimulationLabelText(i, pts));
            sp = ep;
            ++segIndex;
            ++i;
        }
        Point2D ep = this.getFeedbackChangeForBendPoint(-2147483647).applyToPoint(this.getEndAnchorPoint());
        this.segments.get(segIndex).update(sp, ep, 0.0, this.getArrowLength(), this.getLabelText(pts, pts), this.getSimulationLabelText(pts, pts));
        this.endFeedbackHandle.setX(ep.getX() - fs2);
        this.endFeedbackHandle.setY(ep.getY() - fs2);
        this.endFeedbackHandle.setWidth(feedbackSize);
        this.endFeedbackHandle.setHeight(feedbackSize);
        Paint color = this.getLineColor();
        IMVCBundle mvcBundle = this.getMVCBundle();
        if (mvcBundle.hasTag(DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG)) {
            color = this.getHighlightIncomingLinkColor();
        } else if (mvcBundle.hasTag(DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG)) {
            color = this.getHighlightOutgoingLinkColor();
        } else if (mvcBundle.hasTag(DiagramViewerDefaultTags.PRIMARY_SELECTION_TAG)) {
            color = mvcBundle.hasTag(DiagramViewerDefaultTags.FOCUS_TAG) ? this.getSelectionFocusedColor() : this.getSelectionNotFocusedColor();
        }
        for (LineSegment seg : this.segments) {
            seg.setStrokeColor(color);
        }
    }

    @Override
    public boolean enableVisual() {
        return true;
    }

    @Override
    public boolean enableInteraction() {
        return true;
    }

    @Override
    public DiagramCoordinate getStartAnchorPoint() {
        DiagramCoordinate target;
        IAnchorageMVCBundle start = this.getLinkBundle().getStartAnchorage();
        Rectangle2D sb = start.getVisual().getCurrentBounds();
        int pts = this.getNumberOfBendPoints();
        if (pts == 0) {
            IAnchorageMVCBundle end = this.getLinkBundle().getEndAnchorage();
            Rectangle2D eb = end.getVisual().getCurrentBounds();
            target = new DiagramCoordinate(eb.getMinX() + eb.getWidth() / 2.0, eb.getMinY() + eb.getHeight() / 2.0);
        } else {
            target = this.getCurrentBendPointLocation(0);
        }
        return this.getStartAnchorLocation(sb, target);
    }

    @Override
    public DiagramCoordinate getEndAnchorPoint() {
        DiagramCoordinate target;
        IAnchorageMVCBundle end = this.getLinkBundle().getEndAnchorage();
        Rectangle2D eb = end.getVisual().getCurrentBounds();
        int pts = this.getNumberOfBendPoints();
        if (pts == 0) {
            IAnchorageMVCBundle start = this.getLinkBundle().getStartAnchorage();
            Rectangle2D sb = start.getVisual().getCurrentBounds();
            target = new DiagramCoordinate(sb.getMinX() + sb.getWidth() / 2.0, sb.getMinY() + sb.getHeight() / 2.0);
        } else {
            target = this.getCurrentBendPointLocation(pts - 1);
        }
        return this.getEndAnchorLocation(eb, target);
    }

    @Override
    public void applySelectedFocusedEffect(DiagramLayers layers) {
        LinkMVCBundle bundle = this.getLinkBundle();
        Paint interactionColor = this.getInteractionColor();
        Paint selectionFocusedColor = this.getSelectionFocusedColor();
        for (LineSegment seg : this.segments) {
            seg.setStrokeColor(selectionFocusedColor);
            seg.setClickableLinesColor(interactionColor);
            seg.addFeedbackNodes(layers, bundle);
        }
        DiagramLayers.ILayer linkInteractionLayer = layers.getLinkInteractionLayer();
        linkInteractionLayer.add((Node)this.startFeedbackHandle, bundle);
        linkInteractionLayer.add((Node)this.endFeedbackHandle, bundle);
    }

    @Override
    public void applySelectedNotFocusedEffect(DiagramLayers layers) {
        this.removeFeedback(layers, this.getSelectionNotFocusedColor());
    }

    @Override
    protected void applyNotSelectedEffect(DiagramLayers layers) {
        this.removeFeedback(layers, this.getLineColor());
    }

    private void removeFeedback(DiagramLayers layers, Paint lineColor) {
        Paint interactionColor = this.getInteractionColor();
        for (LineSegment seg : this.segments) {
            seg.setStrokeColor(lineColor);
            seg.setClickableLinesColor(interactionColor);
            seg.removeFeedbackNodes(layers);
        }
        DiagramLayers.ILayer linkInteractionLayer = layers.getLinkInteractionLayer();
        linkInteractionLayer.remove((Node)this.startFeedbackHandle);
        linkInteractionLayer.remove((Node)this.endFeedbackHandle);
    }

    protected abstract DiagramCoordinate getStartAnchorLocation(Rectangle2D var1, DiagramCoordinate var2);

    protected abstract DiagramCoordinate getEndAnchorLocation(Rectangle2D var1, DiagramCoordinate var2);

    protected Paint getSelectionFocusedColor() {
        return Color.RED;
    }

    protected Paint getSelectionNotFocusedColor() {
        return Color.ORANGE;
    }

    protected Paint getLineColor() {
        return Color.BLACK;
    }

    private DiagramCoordinate getCurrentBendPointLocation(int bendPointIndex) {
        if (bendPointIndex >= 0 && bendPointIndex < this.getNumberOfBendPoints()) {
            DiagramCoordinate bendPoint = this.getBendPointLocation(bendPointIndex);
            FeedbackChange chg = this.getFeedbackChangeForBendPoint(bendPointIndex);
            double x = bendPoint.getX() + chg.getDeltaX();
            double y = bendPoint.getY() + chg.getDeltaY();
            return new DiagramCoordinate(x, y);
        }
        throw new IndexOutOfBoundsException("No bend-point exists at index " + bendPointIndex);
    }

    protected abstract Object getBendPointModel(int var1);

    protected abstract int getNumberOfBendPoints();

    protected abstract boolean showArrowOnLastSegment();

    protected boolean useLineArrow() {
        return false;
    }

    protected double getArrowLength() {
        return 10.0;
    }

    protected abstract double getInvisibleSelectionLineWidth();

    protected String getLabelText(int currentSegment, int lastSegment) {
        return null;
    }

    protected String getSimulationLabelText(int currentSegment, int lastSegment) {
        return null;
    }

    private LinkMVCBundle getLinkBundle() {
        return (LinkMVCBundle)this.getMVCBundle();
    }

    @Override
    public Rectangle2D getCurrentBounds() {
        return Rectangle2D.EMPTY;
    }

    @Override
    public int getBendPointIndex(Node node) {
        int superResult = super.getBendPointIndex(node);
        if (superResult != -2147483646) {
            return superResult;
        }
        int i = 0;
        while (i < this.segments.size()) {
            LineSegment ls = this.segments.get(i);
            if (node == ls.getFeedbackHandle() || node == ls.getClickableLine() || node == ls.getVisibleLine()) {
                return i;
            }
            ++i;
        }
        return -2147483646;
    }

    @Override
    public boolean isBendPointHandle(Node node) {
        for (LineSegment ls : this.segments) {
            if (node == ls.getFeedbackHandle()) {
                return true;
            }
            if (node != ls.getClickableLine() && node != ls.getVisibleLine()) continue;
            return false;
        }
        return super.isBendPointHandle(node);
    }

    @Override
    public void requestFocus() {
        if (!this.segments.isEmpty()) {
            this.segments.get(0).getVisibleLine().requestFocus();
        }
    }

    @Override
    public EDragGesture getDragGesture(Node node, DiagramCoordinate diagramLocation) {
        if (node == this.startFeedbackHandle || node == this.endFeedbackHandle) {
            return EDragGesture.RECONNECT_LINK;
        }
        for (LineSegment ls : this.segments) {
            if (node == ls.getFeedbackHandle()) {
                return EDragGesture.MOVE_BENDPOINT;
            }
            if (node != ls.getClickableLine()) continue;
            return EDragGesture.NEW_BENDPOINT;
        }
        return EDragGesture.NONE;
    }

    @Override
    public void enableFeedback() {
        super.enableFeedback();
        for (LineSegment ls : this.segments) {
            ls.setMouseTransparent(false);
        }
    }

    @Override
    public void disableFeedback() {
        super.disableFeedback();
        for (LineSegment ls : this.segments) {
            ls.setMouseTransparent(true);
        }
    }
}

