/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular;

import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.widgets.AlignedText;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.widgets.LinkArrowWidget;

final class LineSegment {
    private final Object bendPointModel;
    private final Line visibleLine;
    private final Line clickableLine;
    private final Rectangle feedbackHandle;
    private final LinkArrowWidget arrowWidget;
    private AlignedText label;
    private Text simulationLabel;
    private final int SIMULATION_OFFSET = 1;

    public LineSegment(double sx, double sy, double ex, double ey, double clickableWidth, double markerSize, boolean showArrow, boolean useLineArrow, double arrowLength, String labelText, String simulationLabelText) {
        this(null, sx, sy, ex, ey, clickableWidth, markerSize, showArrow, useLineArrow, arrowLength, labelText, simulationLabelText);
    }

    public LineSegment(Object bendPointModel, double sx, double sy, double ex, double ey, double clickableWidth, double feedbackSize, boolean showArrow, boolean useLineArrow, double arrowLength, String labelText, String simulationLabelText) {
        this.bendPointModel = bendPointModel;
        this.visibleLine = new Line(sx, sy, ex, ey);
        this.clickableLine = new Line(sx, sy, ex, ey);
        this.clickableLine.setStroke((Paint)Color.TRANSPARENT);
        this.clickableLine.setStrokeWidth(clickableWidth);
        double fs2 = feedbackSize / 2.0;
        this.feedbackHandle = new Rectangle(ex - fs2, ey - fs2, feedbackSize, feedbackSize);
        this.feedbackHandle.setFill((Paint)Color.TRANSPARENT);
        this.feedbackHandle.setStroke((Paint)Color.RED);
        this.arrowWidget = showArrow ? new LinkArrowWidget(useLineArrow, ex, ey, sx, sy, arrowLength) : null;
        if (labelText != null) {
            this.label = new AlignedText();
            this.label.setText(labelText);
            this.label.setAlignment(Pos.BOTTOM_CENTER);
        } else {
            this.label = null;
        }
        if (simulationLabelText != null) {
            this.simulationLabel = new Text(simulationLabelText);
            this.simulationLabel.setTextAlignment(TextAlignment.CENTER);
            this.simulationLabel.setTextOrigin(VPos.TOP);
            this.simulationLabel.setFill((Paint)Color.RED);
        } else {
            this.simulationLabel = null;
        }
    }

    public Object getBendPointModel() {
        return this.bendPointModel;
    }

    public Line getVisibleLine() {
        return this.visibleLine;
    }

    public Line getClickableLine() {
        return this.clickableLine;
    }

    public Rectangle getFeedbackHandle() {
        return this.feedbackHandle;
    }

    public void addLinkNodes(DiagramLayers layers, ILinkMVCBundle bundle, String labelText, String simulationLabelText) {
        DiagramLayers.ILayer visualLayer = layers.getLinkLayer();
        visualLayer.add((Node)this.visibleLine, bundle);
        if (this.arrowWidget != null) {
            visualLayer.add((Node)this.arrowWidget, bundle);
        }
        if (this.label != null) {
            this.label.setText(labelText);
            double lx = (this.visibleLine.getStartX() + this.visibleLine.getEndX()) / 2.0;
            double ly = (this.visibleLine.getStartY() + this.visibleLine.getEndY()) / 2.0;
            this.label.setX(lx);
            this.label.setY(ly);
            layers.getTextLayer().add((Node)this.label, bundle);
            if (this.simulationLabel != null) {
                this.setSimulationLabel(simulationLabelText, lx, ly, this.label.getBoundsInLocal().getHeight());
                layers.getTextLayer().add((Node)this.simulationLabel, bundle);
            }
        }
        DiagramLayers.ILayer interactionLayer = layers.getLinkInteractionLayer();
        interactionLayer.add((Node)this.clickableLine, bundle);
    }

    private void setSimulationLabel(String simulationLabelText, double lx, double ly, double yOffset) {
        this.simulationLabel.setText(simulationLabelText);
        this.simulationLabel.setX(lx);
        this.simulationLabel.setY(ly + yOffset + 1.0);
    }

    public void removeLinkNodes(DiagramLayers layers) {
        DiagramLayers.ILayer visualLayer = layers.getLinkLayer();
        visualLayer.remove((Node)this.visibleLine);
        if (this.arrowWidget != null) {
            visualLayer.remove((Node)this.arrowWidget);
        }
        if (this.label != null) {
            layers.getTextLayer().remove((Node)this.label);
        }
        if (this.simulationLabel != null) {
            layers.getTextLayer().remove((Node)this.simulationLabel);
        }
        DiagramLayers.ILayer interactionLayer = layers.getLinkInteractionLayer();
        interactionLayer.remove((Node)this.clickableLine);
    }

    public void addFeedbackNodes(DiagramLayers layers, ILinkMVCBundle bundle) {
        layers.getLinkInteractionLayer().add((Node)this.feedbackHandle, bundle);
    }

    public void removeFeedbackNodes(DiagramLayers layers) {
        layers.getLinkInteractionLayer().remove((Node)this.feedbackHandle);
    }

    public void setStrokeColor(Paint color) {
        this.visibleLine.setStroke(color);
        if (this.arrowWidget != null) {
            this.arrowWidget.setColor(color);
        }
    }

    public void setClickableLinesColor(Paint color) {
        this.clickableLine.setStroke(color);
    }

    public void update(Point2D sp, Point2D ep, double feedbackSize, double arrowLength, String labelText, String simulationLabelText) {
        double sx = sp.getX();
        double sy = sp.getY();
        this.visibleLine.setStartX(sx);
        this.visibleLine.setStartY(sy);
        this.clickableLine.setStartX(sx);
        this.clickableLine.setStartY(sy);
        double ex = ep.getX();
        double ey = ep.getY();
        this.visibleLine.setEndX(ex);
        this.visibleLine.setEndY(ey);
        this.clickableLine.setEndX(ex);
        this.clickableLine.setEndY(ey);
        double fs2 = feedbackSize / 2.0;
        this.feedbackHandle.setX(ex - fs2);
        this.feedbackHandle.setY(ey - fs2);
        this.feedbackHandle.setWidth(feedbackSize);
        this.feedbackHandle.setHeight(feedbackSize);
        if (this.arrowWidget != null) {
            this.arrowWidget.update(ex, ey, sx, sy, arrowLength);
        }
        if (this.label != null) {
            this.label.setText(labelText);
            double lx = (sx + ex) / 2.0;
            double ly = (sy + ey) / 2.0;
            this.label.setX(lx);
            this.label.setY(ly);
            if (this.simulationLabel != null) {
                this.setSimulationLabel(simulationLabelText, lx, ly, this.label.getBoundsInLocal().getHeight());
            }
        }
    }

    public void setMouseTransparent(boolean transparent) {
        this.visibleLine.setMouseTransparent(transparent);
        this.clickableLine.setMouseTransparent(transparent);
        this.feedbackHandle.setMouseTransparent(transparent);
        if (this.arrowWidget != null) {
            this.arrowWidget.setMouseTransparent(transparent);
        }
        if (this.label != null) {
            this.label.setMouseTransparent(transparent);
        }
        if (this.simulationLabel != null) {
            this.simulationLabel.setMouseTransparent(transparent);
        }
    }
}

