/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular;

import java.util.Objects;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;

public final class RectangularBorderLocation {
    private final Side side;
    private final double offset;
    private final Rectangle2D rectangle;
    private final Dimension2D anchorageSize;

    public RectangularBorderLocation(Side side, double offset, Rectangle2D rectangle, Dimension2D anchorageSize) {
        this.side = Objects.requireNonNull(side);
        this.offset = offset;
        this.rectangle = Objects.requireNonNull(rectangle);
        this.anchorageSize = Objects.requireNonNull(anchorageSize);
    }

    public Side getSide() {
        return this.side;
    }

    public double getOffset() {
        return this.offset;
    }

    public DiagramCoordinate getLocation() {
        if (this.side == Side.TOP) {
            return new DiagramCoordinate(this.offset, -this.anchorageSize.getHeight() / 2.0);
        }
        if (this.side == Side.LEFT) {
            return new DiagramCoordinate(-this.anchorageSize.getWidth() / 2.0, this.offset);
        }
        if (this.side == Side.BOTTOM) {
            return new DiagramCoordinate(this.offset, this.rectangle.getHeight() - this.anchorageSize.getHeight() / 2.0);
        }
        return new DiagramCoordinate(this.rectangle.getWidth() - this.anchorageSize.getWidth() / 2.0, this.offset);
    }

    @Deprecated
    public static final RectangularBorderLocation getClosestLocationOnBounds(Point2D p, Rectangle2D rectangle, Dimension2D span) {
        LocationOnBorderComputation comp = new LocationOnBorderComputation(p, rectangle, span, span);
        RectangularBorderLocation result = new RectangularBorderLocation(comp.getResultSide(), comp.getResultOffset(), rectangle, span);
        return result;
    }

    public static final RectangularBorderLocation getClosestLocationOnBounds(Point2D p, Rectangle2D rectangle, Dimension2D anchorageSize, Dimension2D span) {
        LocationOnBorderComputation comp = new LocationOnBorderComputation(p, rectangle, anchorageSize, span);
        RectangularBorderLocation result = new RectangularBorderLocation(comp.getResultSide(), comp.getResultOffset(), rectangle, anchorageSize);
        return result;
    }

    public String toString() {
        return this.side.toString() + ":" + this.offset;
    }

    private static class LocationOnBorderComputation {
        private double leftRightOffset;
        private Side leftRightSide;
        private double leftRightDistance;
        private double topBottomOffset;
        private Side topBottomSide;
        private double topBottomDistance;

        public LocationOnBorderComputation(Point2D pt, Rectangle2D rectangle, Dimension2D anchorageSize, Dimension2D snap) {
            this.computeLeftRight(pt, rectangle, anchorageSize.getHeight(), snap.getHeight());
            this.computeTopBottom(pt, rectangle, anchorageSize.getWidth(), snap.getWidth());
        }

        private void computeTopBottom(Point2D pt, Rectangle2D rect, double anchorageWidth, double snapWidth) {
            this.topBottomSide = Side.TOP;
            double borderY = 0.0;
            if (pt.getY() > rect.getHeight() / 2.0) {
                this.topBottomSide = Side.BOTTOM;
                borderY = rect.getHeight();
            }
            double borderWidth = rect.getWidth();
            double correctedX = pt.getX() - anchorageWidth / 2.0;
            double distanceY = pt.getY() - borderY;
            double xOffset = 0.0;
            double currentDistance = Math.hypot(correctedX, distanceY);
            double nextOffset = snapWidth;
            while (nextOffset < borderWidth) {
                double nextDistance = Math.hypot(correctedX - nextOffset, distanceY);
                if (nextDistance > currentDistance) break;
                xOffset = nextOffset;
                currentDistance = nextDistance;
                nextOffset += snapWidth;
            }
            this.topBottomOffset = xOffset;
            this.topBottomDistance = currentDistance;
        }

        private void computeLeftRight(Point2D pt, Rectangle2D rect, double anchorageHeight, double snapHeight) {
            this.leftRightSide = Side.LEFT;
            double borderX = 0.0;
            if (pt.getX() > rect.getWidth() / 2.0) {
                this.leftRightSide = Side.RIGHT;
                borderX = rect.getWidth();
            }
            double borderHeight = rect.getHeight();
            double correctedY = pt.getY() - anchorageHeight / 2.0;
            double distanceX = pt.getX() - borderX;
            double yOffset = 0.0;
            double currentDistance = Math.hypot(distanceX, correctedY);
            double nextOffset = snapHeight;
            while (nextOffset < borderHeight) {
                double nextDistance = Math.hypot(distanceX, correctedY - nextOffset);
                if (nextDistance > currentDistance) break;
                yOffset = nextOffset;
                currentDistance = nextDistance;
                nextOffset += snapHeight;
            }
            this.leftRightOffset = yOffset;
            this.leftRightDistance = currentDistance;
        }

        public Side getResultSide() {
            if (this.leftRightDistance <= this.topBottomDistance) {
                return this.leftRightSide;
            }
            return this.topBottomSide;
        }

        public double getResultOffset() {
            if (this.leftRightDistance <= this.topBottomDistance) {
                return this.leftRightOffset;
            }
            return this.topBottomOffset;
        }
    }
}

