/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular;

import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.ContentAnchorageVisualBase;

public abstract class RectangularContentAnchorageVisualBase
extends ContentAnchorageVisualBase {
    public RectangularContentAnchorageVisualBase(IContentAnchorageMVCBundle mvcb) {
        super(mvcb, (Shape)new Rectangle(), (Shape)new Rectangle());
    }

    protected final Rectangle getVisualRectangle() {
        return (Rectangle)this.getVisualShape();
    }

    protected final Rectangle getHitAreaRectangle() {
        return (Rectangle)this.getHitAreaShape();
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        Rectangle2D bounds = this.getCurrentBounds();
        if (this.enableVisual()) {
            Insets i = this.getInsets();
            Rectangle rectangle = this.getVisualRectangle();
            rectangle.setX(bounds.getMinX() + i.getLeft());
            rectangle.setY(bounds.getMinY() + i.getTop());
            double w = bounds.getWidth() - i.getLeft() - i.getRight();
            rectangle.setWidth(w);
            double h = bounds.getHeight() - i.getTop() - i.getBottom();
            rectangle.setHeight(h);
            rectangle.setOpacity(this.getOpacity());
            rectangle.setStrokeWidth(this.getBorderWidth());
            rectangle.setStrokeType(this.getBorderType());
            if (this.getMVCBundle().hasTag(DiagramViewerDefaultTags.HIGHLIGHT_INCOMING_LINK_TAG)) {
                rectangle.setFill(this.getHighlightIncomingLinkColor());
                rectangle.setStroke(this.getHighlightIncomingLinkBorderColor());
            } else if (this.getMVCBundle().hasTag(DiagramViewerDefaultTags.HIGHLIGHT_OUTGOING_LINK_TAG)) {
                rectangle.setFill(this.getHighlightOutgoingLinkColor());
                rectangle.setStroke(this.getHighlightOutgoingLinkBorderColor());
            } else {
                rectangle.setFill(this.getFillColor());
                rectangle.setStroke(this.getBorderColor());
            }
        }
        if (this.enableInteraction()) {
            Rectangle ha = this.getHitAreaRectangle();
            double hitAreaOutSet = this.getHitAreaOutset();
            ha.setX(bounds.getMinX() - hitAreaOutSet);
            ha.setY(bounds.getMinY() - hitAreaOutSet);
            ha.setWidth(bounds.getWidth() + 2.0 * hitAreaOutSet);
            ha.setHeight(bounds.getHeight() + 2.0 * hitAreaOutSet);
            Color interactionColor = this.getInteractionColor();
            ha.setStroke((Paint)interactionColor);
            ha.setFill((Paint)interactionColor);
        }
    }

    protected Insets getInsets() {
        return new Insets(2.0);
    }

    @Override
    protected EDragGesture dragGestureHitTest(Node n, DiagramCoordinate diagramLocation) {
        if (n == this.getHitAreaRectangle()) {
            Rectangle ha = this.getHitAreaRectangle();
            double x = diagramLocation.getLocalX((Node)ha);
            double y = diagramLocation.getLocalY((Node)ha);
            double outset = this.getHitAreaOutset();
            if (x < outset || x > ha.getWidth() - outset || y < outset || y > ha.getHeight() - outset) {
                return EDragGesture.NEW_LINK;
            }
            return EDragGesture.MOVE;
        }
        if (n == this.getVisualRectangle()) {
            return EDragGesture.MOVE;
        }
        return EDragGesture.NONE;
    }
}

