/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular;

import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IOffsetLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.ISideLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.ContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularBorderLocation;

public abstract class RectangularContentVisualBase
extends ContentVisualBase {
    private static final Dimension2D DEFAULT_CORNER_ARC = new Dimension2D(15.0, 15.0);

    public RectangularContentVisualBase(IContentMVCBundle mvcb) {
        super(mvcb, (Shape)new Rectangle(), (Shape)new Rectangle());
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        Rectangle2D bounds = this.getCurrentBounds();
        double leftX = bounds.getMinX();
        double upperY = bounds.getMinY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (this.enableVisual()) {
            Rectangle rectangle = this.getVisualRectangleShape();
            rectangle.setX(leftX);
            rectangle.setY(upperY);
            rectangle.setWidth(width);
            rectangle.setHeight(height);
            Dimension2D cornerArc = this.getCornerArcDimensions();
            rectangle.setArcWidth(cornerArc.getWidth());
            rectangle.setArcHeight(cornerArc.getHeight());
            rectangle.setOpacity(this.getOpacity());
            rectangle.setStroke(this.getBorderColor());
            rectangle.setStrokeWidth(this.getBorderWidth());
            rectangle.setStrokeType(this.getBorderType());
            rectangle.setFill(this.getFillColor());
        }
        if (this.enableInteraction()) {
            Rectangle ha = this.getHitAreaRectangleShape();
            double lnk = this.getHitAreaStartLinkSize();
            double resize = this.getHitAreaResizeSize();
            ha.setX(leftX - lnk - resize / 2.0);
            ha.setY(upperY - lnk - resize / 2.0);
            ha.setWidth(lnk + resize + width + lnk);
            ha.setHeight(lnk + resize + height + lnk);
            Color interactionColor = this.getInteractionColor();
            ha.setStroke((Paint)interactionColor);
            ha.setFill((Paint)interactionColor);
        }
    }

    @Override
    public DiagramCoordinate getAnchorageLocation(IContentAnchorageVisual visual) {
        Rectangle2D pb = this.getCurrentBounds();
        Side side = visual.getLayout(ISideLayout.class).getSide();
        double offset = visual.getLayout(IOffsetLayout.class).getOffset();
        RectangularBorderLocation rbl = new RectangularBorderLocation(side, offset, pb, visual.getDimensions());
        return rbl.getLocation();
    }

    @Override
    public DiagramCoordinate getLinkAnchorage(DiagramCoordinate indication) {
        Rectangle2D b = this.getCurrentBounds();
        Dimension2D dummy = new Dimension2D(1.0, 1.0);
        RectangularBorderLocation loc = RectangularBorderLocation.getClosestLocationOnBounds(indication.add(-b.getMinX(), -b.getMinY()), b, dummy, dummy);
        return loc.getLocation().add(b.getMinX(), b.getMinY());
    }

    protected Dimension2D getCornerArcDimensions() {
        return DEFAULT_CORNER_ARC;
    }

    @Override
    protected EDragGesture dragGestureHitTest(Node node, DiagramCoordinate diagramLocation) {
        if (node == this.getHitAreaShape()) {
            return RectangularContentVisualBase.getRectangularShapeDragGesture(node, diagramLocation, this.getHitAreaStartLinkSize(), this.getHitAreaResizeSize());
        }
        if (node == this.getVisualShape() || node == this.text) {
            return EDragGesture.MOVE;
        }
        return EDragGesture.NONE;
    }

    static EDragGesture getRectangularShapeDragGesture(Node node, DiagramCoordinate diagramLocation, double startLinkSize, double resizeAreaSize) {
        double x = diagramLocation.getLocalX(node);
        double y = diagramLocation.getLocalY(node);
        Bounds bounds = node.getBoundsInLocal();
        double inset = startLinkSize + resizeAreaSize;
        double moveWidth = bounds.getWidth() - 2.0 * inset;
        double moveHeight = bounds.getHeight() - 2.0 * inset;
        Rectangle2D moveArea = new Rectangle2D(inset, inset, Math.max(moveWidth, 0.0), Math.max(moveHeight, 0.0));
        if (moveArea.contains(x, y)) {
            return EDragGesture.MOVE;
        }
        if (x < startLinkSize || y < startLinkSize || x > bounds.getWidth() - startLinkSize || y > bounds.getHeight() - startLinkSize) {
            return EDragGesture.NEW_LINK;
        }
        if (x > bounds.getWidth() - inset && y >= startLinkSize && y <= bounds.getHeight() - inset) {
            return EDragGesture.RESIZE_H;
        }
        if (y > bounds.getHeight() - inset && x >= startLinkSize && x <= bounds.getWidth() - inset) {
            return EDragGesture.RESIZE_V;
        }
        if (x > bounds.getWidth() - inset && y > bounds.getHeight() - inset) {
            return EDragGesture.RESIZE_VH;
        }
        return EDragGesture.NONE;
    }

    protected final Rectangle getVisualRectangleShape() {
        return (Rectangle)this.getVisualShape();
    }

    protected final Rectangle getHitAreaRectangleShape() {
        return (Rectangle)this.getHitAreaShape();
    }

    protected double getHitAreaStartLinkSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }

    protected double getHitAreaResizeSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }
}

