/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular;

import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IOffsetLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.ISideLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.base.ContentVisualBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularBorderLocation;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularContentVisualBase;

public abstract class RhomboidContentVisualBase
extends ContentVisualBase {
    private static final double DEFAULT_OFFSET_MULTIPLIER = 3.0;
    private static final Dimension2D DEFAULT_CORNER_ARC = new Dimension2D(15.0, 15.0);

    public RhomboidContentVisualBase(IContentMVCBundle mvcb) {
        super(mvcb, (Shape)new Path(), (Shape)new Path());
    }

    @Override
    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        Rectangle2D bounds = this.getCurrentBounds();
        double leftX = bounds.getMinX();
        double upperY = bounds.getMinY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (this.enableVisual()) {
            Path path = this.getVisualPathShape();
            path.setOpacity(this.getOpacity());
            path.setStroke(this.getBorderColor());
            path.setStrokeWidth(this.getBorderWidth());
            path.setStrokeType(this.getBorderType());
            path.setFill(this.getFillColor());
            this.makePath(leftX, upperY, width, height, path);
        }
        if (this.enableInteraction()) {
            Path ha = this.getHitAreaPathShape();
            double lnk = this.getHitAreaStartLinkSize();
            double resize = this.getHitAreaResizeSize();
            double lr = lnk + resize;
            this.makePath(leftX - lr, upperY - lr, width + 2.0 * lr, height + 2.0 * lr, ha);
            Color interactionColor = this.getInteractionColor();
            ha.setStroke((Paint)interactionColor);
            ha.setFill((Paint)interactionColor);
        }
    }

    private void makePath(double x, double y, double w, double h, Path p) {
        double offset = this.getOffset();
        ObservableList pes = p.getElements();
        pes.clear();
        pes.add((Object)new MoveTo(x, y + h));
        pes.add((Object)new LineTo(x + w - offset, y + h));
        pes.add((Object)new LineTo(x + w, y));
        pes.add((Object)new LineTo(x + offset, y));
        pes.add((Object)new ClosePath());
    }

    public double getOffset() {
        return 3.0 * this.getViewer().getFeatures().getHorizontalSpacing();
    }

    @Override
    public DiagramCoordinate getAnchorageLocation(IContentAnchorageVisual visual) {
        Rectangle2D pb = this.getCurrentBounds();
        double rhomboidOffset = this.getOffset();
        Dimension2D anchorageSize = visual.getDimensions();
        Side side = visual.getLayout(ISideLayout.class).getSide();
        double anchorageOffset = visual.getLayout(IOffsetLayout.class).getOffset();
        if (side == Side.LEFT) {
            double lx = rhomboidOffset / 2.0 - anchorageSize.getWidth() / 2.0;
            double ly = pb.getHeight() / 2.0 - anchorageSize.getHeight() / 2.0;
            return new DiagramCoordinate(lx, ly);
        }
        if (side == Side.RIGHT) {
            double lx = pb.getWidth() - rhomboidOffset / 2.0 - anchorageSize.getWidth() / 2.0;
            double ly = pb.getHeight() / 2.0 - anchorageSize.getHeight() / 2.0;
            return new DiagramCoordinate(lx, ly);
        }
        RectangularBorderLocation rbl = new RectangularBorderLocation(side, anchorageOffset, pb, anchorageSize);
        return rbl.getLocation();
    }

    @Override
    public DiagramCoordinate getLinkAnchorage(DiagramCoordinate indication) {
        Rectangle2D b = this.getCurrentBounds();
        Dimension2D dummy = new Dimension2D(1.0, 1.0);
        RectangularBorderLocation loc = RectangularBorderLocation.getClosestLocationOnBounds(indication.add(-b.getMinX(), -b.getMinY()), b, dummy, dummy);
        return loc.getLocation().add(b.getMinX(), b.getMinY());
    }

    protected Dimension2D getCornerArcDimensions() {
        return DEFAULT_CORNER_ARC;
    }

    @Override
    protected EDragGesture dragGestureHitTest(Node node, DiagramCoordinate diagramLocation) {
        if (node == this.getHitAreaShape()) {
            return RectangularContentVisualBase.getRectangularShapeDragGesture(node, diagramLocation, this.getHitAreaStartLinkSize(), this.getHitAreaResizeSize());
        }
        if (node == this.getVisualShape() || node == this.text) {
            return EDragGesture.MOVE;
        }
        return EDragGesture.NONE;
    }

    protected final Path getVisualPathShape() {
        return (Path)this.getVisualShape();
    }

    protected final Path getHitAreaPathShape() {
        return (Path)this.getHitAreaShape();
    }

    protected double getHitAreaStartLinkSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }

    protected double getHitAreaResizeSize() {
        return this.getViewer().getFeatures().getMaximumSpacing();
    }

    @Override
    protected DiagramCoordinate getTextAnchorLocation() {
        DiagramCoordinate textAnchorLocation = super.getTextAnchorLocation();
        return textAnchorLocation.add(this.getOffset() / 2.0, 0.0);
    }
}

