/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.widgets;

import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;

public final class ExpandCollapseWidget
extends Group {
    private final Rectangle borderRect = new Rectangle();
    private final Line horizontalLine = new Line();
    private final Line verticalLine = new Line();

    public ExpandCollapseWidget(double x, double y, double w, double h, double inset) {
        this.update(x, y, w, h, inset);
        ObservableList c = this.getChildren();
        c.add((Object)this.borderRect);
        c.add((Object)this.horizontalLine);
        this.setColor((Paint)Color.BLACK, (Paint)Color.TRANSPARENT);
    }

    public void update(double x, double y, double w, double h, double inset) {
        this.borderRect.setX(x);
        this.borderRect.setY(y);
        this.borderRect.setWidth(w);
        this.borderRect.setHeight(h);
        this.horizontalLine.setStartX(x + inset);
        this.horizontalLine.setEndX(x + w - inset);
        this.horizontalLine.setStartY(y + h / 2.0);
        this.horizontalLine.setEndY(y + h / 2.0);
        this.verticalLine.setStartX(x + w / 2.0);
        this.verticalLine.setEndX(x + w / 2.0);
        this.verticalLine.setStartY(y + inset);
        this.verticalLine.setEndY(y + h - inset);
    }

    public void setState(boolean expanded) {
        if (expanded) {
            this.getChildren().remove((Object)this.verticalLine);
        } else if (this.verticalLine.getParent() != this) {
            this.getChildren().add((Object)this.verticalLine);
        }
    }

    public void setColor(Paint stroke, Paint fill) {
        this.borderRect.setFill(fill);
        this.borderRect.setStroke(stroke);
        this.verticalLine.setStroke(stroke);
        this.horizontalLine.setStroke(stroke);
    }

    public boolean isHit(Node hit) {
        return hit == this || hit.getParent() == this;
    }
}

