/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.lwfxef.visual.widgets;

import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public final class LinkArrowWidget
extends Group {
    private final boolean useLineArrows;
    private double arrowLength;

    public LinkArrowWidget(boolean useLineArrows, double anchorX, double anchorY, double directionX, double directionY, double arrowLength) {
        this.useLineArrows = useLineArrows;
        this.arrowLength = arrowLength;
        if (useLineArrows) {
            this.addLines(anchorX, anchorY, directionX, directionY);
        } else {
            this.addFilledArrow(anchorX, anchorY, directionX, directionY);
        }
    }

    private void addFilledArrow(double anchorX, double anchorY, double directionX, double directionY) {
        ObservableList children = this.getChildren();
        children.clear();
        Path p = new Path();
        p.setFill((Paint)Color.BLACK);
        p.setStrokeWidth(1.0);
        children.add((Object)p);
        this.updatePath(p, anchorX, anchorY, directionX, directionY);
    }

    private void updatePath(Path p, double anchorX, double anchorY, double directionX, double directionY) {
        double angle = Math.atan2(directionX - anchorX, directionY - anchorY);
        double angleLeft = angle - 0.5235987755982988;
        double lx = anchorX + Math.sin(angleLeft) * this.arrowLength;
        double ly = anchorY + Math.cos(angleLeft) * this.arrowLength;
        double angleRight = angle + 0.5235987755982988;
        double rx = anchorX + Math.sin(angleRight) * this.arrowLength;
        double ry = anchorY + Math.cos(angleRight) * this.arrowLength;
        ObservableList l = p.getElements();
        l.clear();
        l.add((Object)new MoveTo(anchorX, anchorY));
        l.add((Object)new LineTo(lx, ly));
        l.add((Object)new LineTo(rx, ry));
        l.add((Object)new LineTo(anchorX, anchorY));
    }

    private void addLines(double anchorX, double anchorY, double directionX, double directionY) {
        ObservableList children = this.getChildren();
        children.clear();
        Line leftLine = new Line(0.0, 0.0, 0.0, 0.0);
        children.add((Object)leftLine);
        Line rightLine = new Line(0.0, 0.0, 0.0, 0.0);
        children.add((Object)rightLine);
        this.updateLines(anchorX, anchorY, directionX, directionY);
    }

    private void updateLines(double anchorX, double anchorY, double directionX, double directionY) {
        Line left = (Line)this.getChildren().get(0);
        double angle = Math.atan2(directionX - anchorX, directionY - anchorY);
        double angleLeft = angle - 0.7853981633974483;
        double lx = anchorX + Math.sin(angleLeft) * this.arrowLength;
        double ly = anchorY + Math.cos(angleLeft) * this.arrowLength;
        left.setStartX(anchorX);
        left.setStartY(anchorY);
        left.setEndX(lx);
        left.setEndY(ly);
        Line right = (Line)this.getChildren().get(1);
        double angleRight = angle + 0.7853981633974483;
        double rx = anchorX + Math.sin(angleRight) * this.arrowLength;
        double ry = anchorY + Math.cos(angleRight) * this.arrowLength;
        right.setStartX(anchorX);
        right.setStartY(anchorY);
        right.setEndX(rx);
        right.setEndY(ry);
    }

    public void update(double anchorX, double anchorY, double directionX, double directionY, double arrowLength) {
        this.arrowLength = arrowLength;
        if (this.useLineArrows) {
            this.updateLines(anchorX, anchorY, directionX, directionY);
        } else {
            Path p = (Path)this.getChildren().get(0);
            this.updatePath(p, anchorX, anchorY, directionX, directionY);
        }
    }

    public void setColor(Paint color) {
        if (this.useLineArrows) {
            ((Line)this.getChildren().get(0)).setStroke(color);
            ((Line)this.getChildren().get(1)).setStroke(color);
        } else {
            Path p = (Path)this.getChildren().get(0);
            p.setStroke(color);
            p.setFill(color);
        }
    }
}

