/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.style;

import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import org.fortiss.tooling.common.ui.javafx.style.ColorStyleBase;

public final class FontStyle
extends ColorStyleBase {
    public static final FontStyle BLACK_VERDANA_18PT = new FontStyle("Verdana", 18.0, Color.BLACK);
    public static final FontStyle BLACK_VERDANA_16PT = new FontStyle("Verdana", 16.0, Color.BLACK);
    public static final FontStyle BLACK_VERDANA_14PT = new FontStyle("Verdana", 14.0, Color.BLACK);
    public static final FontStyle BLACK_VERDANA_12PT = new FontStyle("Verdana", 12.0, Color.BLACK);
    public static final FontStyle BLACK_VERDANA_10PT = new FontStyle("Verdana", 10.0, Color.BLACK);
    public static final FontStyle BLACK_VERDANA_8PT = new FontStyle("Verdana", 8.0, Color.BLACK);
    private final Font font;

    public FontStyle(String fontFamily, double size, Color rgbColor) {
        super(rgbColor);
        this.font = Font.font((String)fontFamily, (double)size);
    }

    public void applyStyle(GraphicsContext gc) {
        gc.setStroke((Paint)this.getColor());
        gc.setFill((Paint)this.getColor());
        gc.setFont(this.font);
        gc.setFontSmoothingType(FontSmoothingType.LCD);
    }

    public void drawText(GraphicsContext gc, String text, double x, double y) {
        gc.save();
        this.applyStyle(gc);
        gc.fillText(text, x, y);
        gc.restore();
    }

    public Dimension2D getTextBounds(String text) {
        Text t = new Text(text);
        t.setFont(this.font);
        Bounds b = t.getBoundsInLocal();
        Dimension2D dim = new Dimension2D(b.getWidth(), b.getHeight());
        return dim;
    }
}

