/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.style;

import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.tooling.common.ui.javafx.style.ColorStyleBase;
import org.fortiss.tooling.common.ui.javafx.style.StrokeStyle;

public final class LineStyle
extends ColorStyleBase {
    public static final LineStyle SOLID_BLACK_1PT = new LineStyle(Color.BLACK, 1.0, StrokeStyle.SOLID);
    private final StrokeStyle strokeStyle;
    private final double width;

    public LineStyle(Color rgbColor, double width, StrokeStyle strokeStyle) {
        super(rgbColor);
        this.width = width;
        this.strokeStyle = strokeStyle;
    }

    public LineStyle(Color rgbColor) {
        this(rgbColor, 1.0, StrokeStyle.SOLID);
    }

    public void applyStyle(GraphicsContext gc) {
        gc.setStroke((Paint)this.getColor());
        gc.setLineWidth(this.width);
        this.strokeStyle.applyStyle(gc);
    }

    public void drawLine(GraphicsContext gc, double x1, double y1, double x2, double y2) {
        this.applyStyle(gc);
        gc.strokeLine(x1, y1, x2, y2);
    }
}

