/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.util;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class GraphicUtils {
    private static final HashMap<String, Image> imageCache = new HashMap();

    private static String getURIString(String pluginId, String localPath) {
        if (!pluginId.endsWith("/") && !((String)localPath).startsWith("/")) {
            localPath = "/" + (String)localPath;
        }
        return "platform:/plugin/" + pluginId + (String)localPath;
    }

    public static Image getFXImage(String pluginId, String localPath) {
        if (pluginId == null || localPath == null) {
            return null;
        }
        String uri = GraphicUtils.getURIString(pluginId, localPath);
        if (uri == null) {
            return null;
        }
        return GraphicUtils.getFXImageFromURI(uri);
    }

    public static Image getFXImageFromURI(String uri) {
        Image cacheImage = imageCache.get(uri);
        if (cacheImage == null) {
            InputStream in = null;
            try {
                in = new URL(uri).openStream();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (in != null) {
                cacheImage = new Image(in);
            }
            imageCache.put(uri, cacheImage);
        }
        return cacheImage;
    }

    public static Color convertColor(org.eclipse.swt.graphics.Color swtColor) {
        return Color.rgb((int)swtColor.getRed(), (int)swtColor.getGreen(), (int)swtColor.getBlue(), (double)((double)swtColor.getAlpha() / 255.0));
    }
}

