/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.ui.javafx.util;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.function.Predicate;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Tooltip;

public final class JavaFXUtils {
    private JavaFXUtils() {
    }

    public static <T> T loadFXML(URL fxmlResource, Object controller) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setClassLoader(controller.getClass().getClassLoader());
        fxmlLoader.setController(controller);
        fxmlLoader.setLocation(fxmlResource);
        return (T)fxmlLoader.load();
    }

    public static <T extends Node> T findParentNode(Parent start, Class<T> clazz) {
        return (T)JavaFXUtils.findParentNode(start, (Node t) -> clazz.isInstance(t));
    }

    public static Node findParentById(Parent start, String id) {
        return JavaFXUtils.findParentNode(start, (Node t) -> t.getId().equals(id));
    }

    public static <T extends Node> T findParentByIdType(Parent start, String id, Class<T> type) {
        return (T)JavaFXUtils.findChildNode(start, (Node t) -> type.isAssignableFrom(type) && t.getId().equals(id));
    }

    public static Node findParentNode(Parent start, Predicate<Node> pred) {
        while (start != null) {
            if (!pred.test((Node)(start = start.getParent()))) continue;
            return start;
        }
        return null;
    }

    public static <T extends Node> T findChildNode(Parent start, Class<T> clazz) {
        return (T)JavaFXUtils.findChildNode(start, (Node t) -> clazz.isInstance(t));
    }

    public static Node findChildById(Parent start, String id) {
        return JavaFXUtils.findChildNode(start, (Node t) -> t.getId().equals(id));
    }

    public static <T extends Node> T findChildByIdType(Parent start, String id, Class<T> type) {
        return (T)JavaFXUtils.findChildNode(start, (Node t) -> t.getId() != null && t.getId().equals(id) && type.isAssignableFrom(t.getClass()));
    }

    public static Node findChildNode(Parent start, Predicate<Node> pred) {
        LinkedList children = new LinkedList();
        children.addAll(start.getChildrenUnmodifiable());
        while (!children.isEmpty()) {
            Node child = (Node)children.poll();
            if (pred.test(child)) {
                return child;
            }
            if (!(child instanceof Parent)) continue;
            children.addAll(((Parent)child).getChildrenUnmodifiable());
        }
        return null;
    }

    public static Tooltip createToolTip(String description) {
        Tooltip value = new Tooltip(description);
        value.setStyle("-fx-background-color: yellow; -fx-text-fill: black;");
        return value;
    }
}

