/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.editor;

import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.fortiss.af3.project.model.ProjectConfiguration;
import org.fortiss.af3.project.model.configuration.TypeSystemConfiguration;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.ITypeSystemHandler;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;

public final class ProjectConfigurationEditor
extends EditorBase<ProjectConfiguration> {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Combo combo;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText("Project Configuration");
        this.form.getBody().setLayout((Layout)new ColumnLayout());
        this.createSections();
    }

    private void createSections() {
        this.createTypeSysteConfigurationSection();
        this.createDevelopmentProcessConfigurationSection();
    }

    private void createDevelopmentProcessConfigurationSection() {
        this.createNewSection("Development Process Configuration", "Choose a development process to be used.", this.toolkit, this.form.getForm());
    }

    private void createTypeSysteConfigurationSection() {
        Composite client = this.createNewSection("Type System Configuration", "Choose the type system to be used.", this.toolkit, this.form.getForm());
        final TypeSystemConfiguration typeSystemConfiguration = (TypeSystemConfiguration)ReflectionUtils.pickInstanceOf(TypeSystemConfiguration.class, (Collection)((ProjectConfiguration)this.editedObject).getConfigurationElements());
        SelectionAdapter comboListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ITypeSystemHandler handler = (ITypeSystemHandler)ITypeSystemService.INSTANCE.getAllRegisteredHandlers().get(ProjectConfigurationEditor.this.combo.getSelectionIndex());
                if (handler != null) {
                    ProjectConfigurationEditor.this.executeCommand(new Runnable(){

                        @Override
                        public void run() {
                            typeSystemConfiguration.setTypesystem(handler.getTypeSystemInstance());
                        }
                    });
                }
            }
        };
        List handlers = ITypeSystemService.INSTANCE.getAllRegisteredHandlers();
        String[] items = new String[handlers.size()];
        int current = -1;
        int i = 0;
        while (i < handlers.size()) {
            ITypeSystemHandler handler = (ITypeSystemHandler)handlers.get(i);
            items[i] = handler.getDisplayName();
            if (handler.isHandlerOf(typeSystemConfiguration.getTypesystem())) {
                current = i;
            }
            ++i;
        }
        this.combo = new Combo(client, 2060);
        this.combo.setItems(items);
        this.combo.select(current);
        this.combo.addSelectionListener((SelectionListener)comboListener);
    }

    private Composite createNewSection(String title, String description, FormToolkit toolkit, Form form) {
        Section section = toolkit.createSection(form.getBody(), 450);
        section.setText(title);
        section.setDescription(description);
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout(3, false));
        return client;
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }
}

