/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fortiss.af3.project.extension.IExecutionTarget;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.services.IExecutionService;
import org.fortiss.af3.project.utils.ProjectUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;

public abstract class EasyStartMenuBase
implements IContextMenuContributor {
    private boolean startActionErrorFlag = false;
    protected IExecutionTarget executionTarget;

    public EasyStartMenuBase(IExecutionTarget executionTarget) {
        this.executionTarget = executionTarget;
    }

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof INamedElement && this.acceptSelection((INamedElement)selection, contextProvider)) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new EasyStartAction((INamedElement)selection)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    protected abstract boolean acceptSelection(INamedElement var1, ContextMenuContextProvider var2);

    protected abstract String getActionName();

    protected abstract ImageDescriptor getActionIcon();

    protected abstract String getStartupFailureMessage(Exception var1);

    protected boolean hasError() {
        return this.startActionErrorFlag;
    }

    protected class EasyStartAction
    extends Action {
        protected INamedElement target;

        public EasyStartAction(INamedElement target) {
            super(EasyStartMenuBase.this.getActionName(), EasyStartMenuBase.this.getActionIcon());
            this.target = target;
        }

        public void run() {
            ITopLevelElement tle = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.target);
            if (!MessageUtilsExtended.askSaveDirtyTopLevelElement((ITopLevelElement)tle)) {
                return;
            }
            ExecutionConfiguration execConfig = ProjectUtils.findOrCreateExecutionConfigurationFor((INamedElement)this.target);
            try {
                EasyStartMenuBase.this.startActionErrorFlag = false;
                IExecutionService.INSTANCE.prepareExecutable(execConfig, EasyStartMenuBase.this.executionTarget).execute();
            }
            catch (Exception e) {
                MessageUtils.showError((String)(EasyStartMenuBase.this.getActionName() + " failed to start."), (String)EasyStartMenuBase.this.getStartupFailureMessage(e));
                EasyStartMenuBase.this.startActionErrorFlag = true;
            }
        }
    }
}

