/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.fortiss.af3.project.extension.IExecutionTarget;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.services.IExecutionService;
import org.fortiss.af3.project.ui.AF3ProjectUIActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class ExecutionMenu
implements IContextMenuContributor {
    private final Map<IExecutionTarget, ExecuteAction> actionMap = new HashMap<IExecutionTarget, ExecuteAction>();

    public ExecutionMenu() {
        for (IExecutionTarget target : IExecutionService.INSTANCE.getExecutionTargets()) {
            this.actionMap.put(target, new ExecuteAction(target));
        }
    }

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof ExecutionConfiguration && INavigatorService.getInstance().isNavigatorView(contextProvider)) {
            ExecutionConfiguration configuration = (ExecutionConfiguration)selection;
            UnmodifiableList possibleTargets = IExecutionService.INSTANCE.getExecutionTargets(configuration);
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            for (IExecutionTarget target : possibleTargets) {
                ExecuteAction action = this.actionMap.get(target);
                if (action == null) continue;
                action.setConfiguration(configuration);
                contributionItems.add((IContributionItem)new ActionContributionItem((IAction)action));
            }
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private static class ExecuteAction
    extends Action {
        private final IExecutionTarget target;
        private ExecutionConfiguration configuration;

        public ExecuteAction(IExecutionTarget target) {
            super(target.getName(), AF3ProjectUIActivator.getImageDescriptor("icons/execution_configuration.gif"));
            this.target = target;
        }

        public void run() {
            ITopLevelElement tle = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.configuration);
            if (!MessageUtilsExtended.askSaveDirtyTopLevelElement((ITopLevelElement)tle)) {
                return;
            }
            try {
                IExecutionService.INSTANCE.prepareExecutable(this.configuration, this.target).execute();
            }
            catch (Exception e) {
                LoggingUtils.error((Plugin)AF3ProjectUIActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
        }

        public void setConfiguration(ExecutionConfiguration configuration) {
            this.configuration = configuration;
        }
    }
}

