/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.quality;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;
import org.fortiss.tooling.ext.quality.ui.ModelQualityUIActivator;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;

public class ModelQualityContextMenuContributor
implements IContextMenuContributor {
    private static final String MENU_NAME = "Extract metrics from git repository";

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (!(selection instanceof FileProject)) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionContributionItem((IAction)new MetricExtractionAction(selection)));
    }

    public String getMenuSectionID() {
        return "bottommost";
    }

    protected ImageDescriptor getActionIcon() {
        return ModelQualityUIActivator.getImageDescriptor((String)"icons/metric.png");
    }

    protected class MetricExtractionAction
    extends Action {
        private final EObject model;

        public MetricExtractionAction(EObject model) {
            super(ModelQualityContextMenuContributor.MENU_NAME, ModelQualityContextMenuContributor.this.getActionIcon());
            this.model = model;
        }

        public void run() {
            Shell composite = Display.getCurrent().getActiveShell();
            String saveFileName = this.openFileDialog(composite.getShell());
            if (saveFileName == null) {
                return;
            }
            IModelQualityService mqs = IModelQualityService.getInstance();
            if (!mqs.scheduleGitMetricExtraction(this.model, new File(saveFileName).toPath())) {
                MessageUtilsExtended.showErrorInUIThread((String)"Metric extraction failed", (String)"Model quality service is not available (e.g., model not under Git version control, service is busy).");
            }
        }

        private String openFileDialog(Shell shell) {
            FileDialog fileChooser = new FileDialog(shell, 8192);
            fileChooser.setText("Save the extracted Metrics");
            fileChooser.setFilterExtensions(new String[]{".csv"});
            return fileChooser.open();
        }

        public boolean isEnabled() {
            return IModelQualityService.getInstance().isAvailable();
        }
    }
}

