/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.utils;

import java.io.IOException;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.project.AF3ProjectActivator;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.impl.FileProjectImpl;
import org.fortiss.af3.project.utils.ExternalFileUtils;
import org.fortiss.tooling.kernel.utils.EMFResourceUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class ExportProjectUtils {
    public static String fileSelectionDialog(String projectName) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setOverwrite(true);
        fd.setText("Select target file of AF3-Project");
        fd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        String[] filterExt = new String[]{"*.af3_23"};
        fd.setFilterExtensions(filterExt);
        fd.setFileName(projectName);
        return fd.open();
    }

    public static FileProject getSelectedFileProject() {
        TreeSelection treeSelection;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection != null && !selection.isEmpty() && selection.getClass().equals(TreeSelection.class) && (treeSelection = (TreeSelection)selection).getPaths().length == 1 && treeSelection.getFirstElement().getClass().equals(FileProjectImpl.class)) {
            return (FileProjectImpl)treeSelection.getFirstElement();
        }
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Export aborted", (String)"Please select one AF3-Project that should be exported!");
        return null;
    }

    public static void exportProject(FileProject project, URI sourcePath, URI targetPath) {
        try {
            ExportProjectUtils.fixIds((EObject)project);
            Resource r = new ResourceSetImpl().createResource(targetPath);
            r.getContents().add((Object)project);
            r.save(EMFResourceUtils.buildOptionsMap());
            ExternalFileUtils.copyExternalReferences((FileProject)project, (URI)sourcePath, (URI)targetPath);
        }
        catch (IOException e) {
            LoggingUtils.error((Plugin)AF3ProjectActivator.getDefault(), (String)"File cannot be exported!", (Throwable)e);
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("File cannot be exported!\n" + e.toString()));
        }
    }

    private static void fixIds(EObject rootModelElement) {
        if (UniqueIDUtils.removeDuplicateIds((EObject)rootModelElement)) {
            MessageUtils.showWarningAsync((String)"Duplicate IDs found during export", (String)"The model file to be exported contained duplicate IDs that have been corrected.\n\nPlease report this incident since it might result in corrupted models.");
        }
        UniqueIDUtils.generateMissingIDs((EObject)rootModelElement, (int)UniqueIDUtils.getLargestID((EObject)rootModelElement));
    }
}

