/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.utils;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.fortiss.af3.project.ui.AF3ProjectUIActivator;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class FolderOrProjectDialogUtils {
    public static final IFolder openFolderDialog() {
        final IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            wRoot.refreshLocal(2, null);
        }
        catch (CoreException e) {
            LoggingUtils.warning((Plugin)AF3ProjectUIActivator.getDefault(), (String)e.getMessage());
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        final IPath af3EclipseProjectPath = FileUtils.getAF3EclipseProject().getFullPath();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(shell, (IContainer)FileUtils.getAF3EclipseProject(), true, "Select an existing folder or enter the path of a new folder.");
        dialog.setValidator(new ISelectionValidator(){

            public String isValid(Object selection) {
                if (!(selection instanceof IPath)) {
                    return "Please select a single path.";
                }
                IPath path = (IPath)selection;
                if (af3EclipseProjectPath.equals((Object)path)) {
                    return "You may not select the \"AF3-Project-Directory\" itself.";
                }
                if (!af3EclipseProjectPath.isPrefixOf(path)) {
                    return "Please select or define a contained by the \"AF3-Project-Directory\".";
                }
                IResource member = wRoot.findMember(path);
                if (member != null && !(member instanceof IFolder)) {
                    return "You may only enter folder paths (i.e., neither paths of existing files nor projects).";
                }
                return null;
            }
        });
        if (dialog.open() != 0) {
            return null;
        }
        IPath path = (IPath)dialog.getResult()[0];
        IResource member = wRoot.findMember(path);
        if (member == null) {
            IFolder folder = wRoot.getFolder(path);
            try {
                FolderOrProjectDialogUtils.mkdir(folder);
                return folder;
            }
            catch (CoreException e) {
                return null;
            }
        }
        return member instanceof IFolder ? (IFolder)member : null;
    }

    private static void mkdir(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                FolderOrProjectDialogUtils.mkdir((IFolder)parent);
            }
            folder.create(false, false, null);
        }
    }
}

