/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.project.ui.AF3ProjectUIActivator;
import org.fortiss.af3.project.ui.utils.NewProjectUiUtils;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.af3.project.utils.ProjectUtils;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ImportProjectUtils {
    public static String fileSelectionDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setText("Select AF3 Project to import");
        fd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        String[] filterExt = new String[]{"*.af3_23", "*.af3_20"};
        fd.setFilterExtensions(filterExt);
        return fd.open();
    }

    public static URI determineTargetFileLocation(String targetFileName) {
        URI targetURI = FileUtils.getDefaultGeneralProjectURI().appendSegment(targetFileName).appendFileExtension("af3_23");
        return ImportProjectUtils.determineTargetFileLocation(targetURI);
    }

    public static URI determineTargetFileLocation(URI fileURI) {
        File targetFile = new File(fileURI.toFileString());
        if (targetFile.exists()) {
            String targetFileName = NewProjectUiUtils.requestFileNameDialog(targetFile);
            if (targetFileName == null) {
                return null;
            }
            fileURI = URI.createURI((String)fileURI.toString().replace(fileURI.lastSegment(), targetFileName));
        }
        return fileURI;
    }

    public static void importUISelectedFile(URI sourceFileURI) {
        File sourceFile = new File(sourceFileURI.toString());
        Path sourcePath = new Path(sourceFile.getPath());
        if (!sourcePath.getFileExtension().equals("af3_23") && !sourcePath.getFileExtension().equals("af3_20")) {
            LoggingUtils.showInfo((String)("Invalid AF3 project file: " + sourcePath.toString() + " is not an AF3 project!"));
            return;
        }
        URI projectURI = FileUtils.getDefaultGeneralProjectURI();
        URI sourceDir = sourceFileURI.trimSegments(1);
        if (sourceDir.equals(projectURI)) {
            LoggingUtils.showError((String)"The selected project is located in the AF3 workspace folder. AF3 does not support importing AF3 projects from this folder. Export the selected project to a different location first.");
            return;
        }
        String sourceFileName = sourceFileURI.lastSegment();
        URI targetFileURI = ImportProjectUtils.determineTargetFileLocation(FileUtils.getDefaultGeneralProjectURI().appendSegment(sourceFileName));
        if (targetFileURI == null) {
            return;
        }
        try {
            ProjectUtils.importFileProject((URI)sourceFileURI, (URI)targetFileURI);
        }
        catch (IOException e) {
            LoggingUtils.error((Plugin)AF3ProjectUIActivator.getDefault(), (String)"Error, cannot import AF3 project!", (Throwable)e);
            MessageUtilsExtended.showErrorInUIThread((String)"Error, cannot import AF3 project!", (String)("File '" + sourceFileName + "' is invalid"));
        }
    }
}

