/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.variability;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.ide.commons.ui.jface.DialogUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.ui.AF3ProjectUIActivator;
import org.fortiss.af3.project.utils.ProjectUtils;
import org.fortiss.af3.project.variability.ConfigureUtils;
import org.fortiss.tooling.ext.variability.ui.configure.ConfigureVariantDialog;
import org.fortiss.tooling.ext.variability.util.VariabilityUtils;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.bind.BindUtils;
import org.fortiss.variability.model.IBindingStrategy;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.features.AbstractFeatureModel;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;
import org.fortiss.variability.util.Pair;

public class ConfigureVariantContextMenuContributor
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof FileProject && VariabilityUtils.canContainVariability((EObject)selection)) {
            CreateVariantAction action = new CreateVariantAction((FileProject)selection);
            return Collections.singletonList(new ActionContributionItem((IAction)action));
        }
        return null;
    }

    public String getMenuSectionID() {
        return "bottommost";
    }

    protected IBindingStrategy getBindingStrategy() {
        return VariabilityModelElementFactory.getRemoveBindingStrategyInstance();
    }

    protected String getContributerLabel() {
        return "Generate Variant of AF3 Project...";
    }

    protected ImageDescriptor getImage() {
        return AF3ProjectUIActivator.getImageDescriptor("icons/project_variant.gif");
    }

    protected FileProject configureVariant(FileProject project, VariantConfiguration varConf) {
        return ConfigureUtils.configureFileProject((FileProject)project, (VariantConfiguration)varConf, (IBindingStrategy)this.getBindingStrategy());
    }

    private class CreateVariantAction
    extends Action {
        private FileProject project;

        public CreateVariantAction(FileProject project) {
            this.project = project;
        }

        public void run() {
            Shell shell = Display.getDefault().getActiveShell();
            AbstractFeatureModel fm = (AbstractFeatureModel)EcoreUtils.pickFirstInstanceOf(AbstractFeatureModel.class, this.project.getRootElements().stream().collect(Collectors.toList()));
            if (fm == null) {
                DialogUtils.openErrorDialogAsync((String)"No Feature Model found", (String)"The project for which you want to create a new variant for, does not contain a Feature Moddel.\n\nAdd and cofigure a Feature Model first.");
                return;
            }
            VariantConfiguration fmc = VariabilityModelElementFactory.createVariantConfiguration((AbstractFeatureModel)fm);
            ConfigureVariantDialog dia = new ConfigureVariantDialog(shell, fmc);
            if (dia.open() == 0) {
                VariantConfiguration varConf = dia.getVariantConfiguration();
                Pair varConfProblem = BindUtils.checkVariantConfiguration((VariantConfiguration)varConf);
                if (varConfProblem != null) {
                    DialogUtils.openErrorDialogAsync((String)"Invalid Variant Configuration", (String)((String)varConfProblem.first));
                    return;
                }
                FileProject newFileProjectVariant = ConfigureVariantContextMenuContributor.this.configureVariant(this.project, varConf);
                EList featureModel = EcoreUtils.pickInstanceOf(AbstractFeatureModel.class, (List)newFileProjectVariant.getRootElements());
                if (featureModel.size() > 0) {
                    EcoreUtil.delete((EObject)((EObject)featureModel.get(0)));
                }
                Date date = new Date();
                String currentDateTime = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(date);
                String newProjName = newFileProjectVariant.getName() + "_var_" + currentDateTime;
                newFileProjectVariant.setName(newProjName);
                String path = "AF3-Project-Directory" + File.separator + newProjName + ".af3_23";
                URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
                try {
                    ProjectUtils.saveProject((FileProject)newFileProjectVariant, (URI)uri);
                }
                catch (IOException e) {
                    DialogUtils.openErrorDialogAsync((String)"Project variant could not be created", (String)"The Project variant could not be created in your AF3 workspace.\n\n This might be due to access restrictions of your file system.");
                    e.printStackTrace();
                }
            }
        }

        public String getText() {
            return ConfigureVariantContextMenuContributor.this.getContributerLabel();
        }

        public ImageDescriptor getImageDescriptor() {
            return ConfigureVariantContextMenuContributor.this.getImage();
        }
    }
}

