/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.ui.wizard;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.ProjectConfiguration;
import org.fortiss.af3.project.model.typesystem.ITypeSystem;
import org.fortiss.af3.project.utils.ProjectModelElementFactory;
import org.fortiss.tooling.kernel.utils.EMFResourceUtils;

public final class NewProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewFileCreationPage page;
    private IStructuredSelection selection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle("AF3 2.x Project");
    }

    public void addPages() {
        this.page = new WizardNewFileCreationPage("newAF3project", this.selection);
        this.page.setFileName("AF3-Project.af3_2x");
        this.page.setTitle("Create New AF3 2.x Project");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IResource resource;
        block3: {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                resource = root.findMember(this.page.getContainerFullPath());
                if (resource.exists() && resource instanceof IContainer) break block3;
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Container does not exist!");
                return false;
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
                return false;
            }
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(this.page.getFileName()));
        FileProject project = ProjectModelElementFactory.createFileProject((String)"NewAF3Project", (ProjectConfiguration)ProjectModelElementFactory.createProjectConfiguration((ITypeSystem)ProjectModelElementFactory.createDummyTypeSystem()));
        EMFResourceUtils.createNewEclipseWorkspaceProject((IFile)file, (EObject)project);
        return true;
    }
}

