/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContextElementStatus implements Enumerator
{
    NEW(0, "New", "New"),
    IN_CONSOLIDATION(1, "InConsolidation", "In consolidation"),
    CONSOLIDATED(2, "Consolidated", "Consolidated");

    public static final int NEW_VALUE = 0;
    public static final int IN_CONSOLIDATION_VALUE = 1;
    public static final int CONSOLIDATED_VALUE = 2;
    private static final ContextElementStatus[] VALUES_ARRAY;
    public static final List<ContextElementStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContextElementStatus[]{NEW, IN_CONSOLIDATION, CONSOLIDATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContextElementStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContextElementStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContextElementStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContextElementStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContextElementStatus get(int value) {
        switch (value) {
            case 0: {
                return NEW;
            }
            case 1: {
                return IN_CONSOLIDATION;
            }
            case 2: {
                return CONSOLIDATED;
            }
        }
        return null;
    }

    private ContextElementStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

