/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RequirementPriority implements Enumerator
{
    HIGH(1, "High", "High - Must-be"),
    NORMAL(2, "Normal", "Normal - Satisfier"),
    LOW(3, "Low", "Low - Delighter");

    public static final int HIGH_VALUE = 1;
    public static final int NORMAL_VALUE = 2;
    public static final int LOW_VALUE = 3;
    private static final RequirementPriority[] VALUES_ARRAY;
    public static final List<RequirementPriority> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RequirementPriority[]{HIGH, NORMAL, LOW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RequirementPriority get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequirementPriority result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequirementPriority getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequirementPriority result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequirementPriority get(int value) {
        switch (value) {
            case 1: {
                return HIGH;
            }
            case 2: {
                return NORMAL;
            }
            case 3: {
                return LOW;
            }
        }
        return null;
    }

    private RequirementPriority(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

