/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RequirementStatus implements Enumerator
{
    IDENTIFIED(0, "Identified", "Identified"),
    IN_ANALYSIS(1, "InAnalysis", "In Analysis"),
    ANALYZED(2, "Analyzed", "Analyzed"),
    REVIEWED(3, "Reviewed", "Reviewed"),
    FROZEN(4, "Frozen", "Frozen"),
    DECLINED(5, "Declined", "Declined"),
    VALIDATED(6, "Validated", "Validated"),
    VERIFIED(7, "Verified", "Verified");

    public static final int IDENTIFIED_VALUE = 0;
    public static final int IN_ANALYSIS_VALUE = 1;
    public static final int ANALYZED_VALUE = 2;
    public static final int REVIEWED_VALUE = 3;
    public static final int FROZEN_VALUE = 4;
    public static final int DECLINED_VALUE = 5;
    public static final int VALIDATED_VALUE = 6;
    public static final int VERIFIED_VALUE = 7;
    private static final RequirementStatus[] VALUES_ARRAY;
    public static final List<RequirementStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RequirementStatus[]{IDENTIFIED, IN_ANALYSIS, ANALYZED, REVIEWED, FROZEN, DECLINED, VALIDATED, VERIFIED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RequirementStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequirementStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequirementStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequirementStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequirementStatus get(int value) {
        switch (value) {
            case 0: {
                return IDENTIFIED;
            }
            case 1: {
                return IN_ANALYSIS;
            }
            case 2: {
                return ANALYZED;
            }
            case 3: {
                return REVIEWED;
            }
            case 4: {
                return FROZEN;
            }
            case 5: {
                return DECLINED;
            }
            case 6: {
                return VALIDATED;
            }
            case 7: {
                return VERIFIED;
            }
        }
        return null;
    }

    private RequirementStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

